/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.mail.filter;

import java.util.Properties;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.SimConfigurationService;
import com.openexchange.mailfilter.internal.MailFilterProperties;
import com.openexchange.mailfilter.services.MailFilterServletServiceRegistry;


public class Common {

    public static SimConfigurationService simConfigurationService;

    public static void prepare(String passwordSource, String masterPassword) {
        simConfigurationService = new SimConfigurationService() {
            @Override
            public Properties getFile(String filename) {
                final Properties properties = new Properties();
                properties.putAll(stringProperties);
                return properties;
            }
        };
        simConfigurationService.stringProperties.put(MailFilterProperties.Values.SIEVE_CREDSRC.property, "imapLogin");
        simConfigurationService.stringProperties.put(MailFilterProperties.Values.SIEVE_LOGIN_TYPE.property, "user");
        simConfigurationService.stringProperties.put(MailFilterProperties.Values.SIEVE_SERVER.property, "localhost");
        simConfigurationService.stringProperties.put(MailFilterProperties.Values.SIEVE_PORT.property, "2000");
        simConfigurationService.stringProperties.put(MailFilterProperties.Values.SCRIPT_NAME.property, "Open-Xchange");
        simConfigurationService.stringProperties.put(MailFilterProperties.Values.SIEVE_AUTH_ENC.property, "UTF-8");
        simConfigurationService.stringProperties.put(MailFilterProperties.Values.NON_RFC_COMPLIANT_TLS_REGEX.property, "^Cyrus.*v([0-1]\\.[0-9].*|2\\.[0-2].*|2\\.3\\.[0-9]|2\\.3\\.[0-9][^0-9].*)$");
        simConfigurationService.stringProperties.put(MailFilterProperties.Values.TLS.property, "false");
        simConfigurationService.stringProperties.put(MailFilterProperties.Values.VACATION_DOMAINS.property, "");
        simConfigurationService.stringProperties.put(MailFilterProperties.Values.SIEVE_CONNECTION_TIMEOUT.property, "30000");
        if (null != passwordSource) {
            simConfigurationService.stringProperties.put(MailFilterProperties.Values.SIEVE_PASSWORDSRC.property, passwordSource);
        }
        if (null != masterPassword) {
            simConfigurationService.stringProperties.put(MailFilterProperties.Values.SIEVE_MASTERPASSWORD.property, masterPassword);
        }
        MailFilterServletServiceRegistry.getServiceRegistry().addService(ConfigurationService.class, simConfigurationService);
    }

}
