/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.osgi;

import com.sun.mail.imap.QueuingIMAPStore;
import com.sun.mail.util.MailLogger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class JavaMailActivator
implements BundleActivator {
    public void start(BundleContext context) throws Exception {
        try {
            MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            HashSet<String> types = new HashSet<String>(Arrays.asList(mc.getMimeTypes()));
            if (!types.contains("text/html")) {
                mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
            }
            if (!types.contains("text/xml")) {
                mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
            }
            if (!types.contains("text/plain")) {
                mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
            }
            if (!types.contains("multipart/*")) {
                mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed; x-java-fallback-entry=true");
            }
            if (!types.contains("message/rfc822")) {
                mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
            }
            CommandMap.setDefaultCommandMap((CommandMap)mc);
        }
        catch (Exception e) {
            MailLogger logger = new MailLogger(JavaMailActivator.class, "JavaMail Activator", true, System.out);
            logger.log(Level.SEVERE, "Error starting JavaMail bundle.", e);
            throw e;
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            QueuingIMAPStore.shutdown();
        }
        catch (Exception e) {
            MailLogger logger = new MailLogger(JavaMailActivator.class, "JavaMail Activator", true, System.out);
            logger.log(Level.SEVERE, "Error stopping JavaMail bundle.", e);
            throw e;
        }
    }
}

