/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPAddress;
import com.sun.mail.imap.protocol.Item;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;

public class ENVELOPE
implements Item {
    static final char[] name = new char[]{'E', 'N', 'V', 'E', 'L', 'O', 'P', 'E'};
    public int msgno;
    public final Date date;
    public final String subject;
    public final InternetAddress[] from;
    public final InternetAddress[] sender;
    public final InternetAddress[] replyTo;
    public final InternetAddress[] to;
    public final InternetAddress[] cc;
    public final InternetAddress[] bcc;
    public final String inReplyTo;
    public final String messageId;
    private static MailDateFormat mailDateFormat = new MailDateFormat();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ENVELOPE(FetchResponse r) throws ParsingException {
        this.msgno = r.getNumber();
        r.skipSpaces();
        if (r.readByte() != 40) {
            throw new ParsingException("ENVELOPE parse error");
        }
        Date date = null;
        String s = r.readString();
        if (s != null) {
            try {
                MailDateFormat mailDateFormat = ENVELOPE.mailDateFormat;
                synchronized (mailDateFormat) {
                    date = ENVELOPE.mailDateFormat.parse(s);
                }
            }
            catch (ParseException pex) {
            }
            catch (RuntimeException pex) {
                // empty catch block
            }
        }
        this.date = date;
        this.subject = r.readString();
        this.from = this.parseAddressList(r);
        this.sender = this.parseAddressList(r);
        this.replyTo = this.parseAddressList(r);
        this.to = this.parseAddressList(r);
        this.cc = this.parseAddressList(r);
        this.bcc = this.parseAddressList(r);
        this.inReplyTo = r.readString();
        this.messageId = r.readString();
        if (r.readByte() != 41) {
            throw new ParsingException("ENVELOPE parse error");
        }
    }

    private InternetAddress[] parseAddressList(Response r) throws ParsingException {
        r.skipSpaces();
        byte b = r.readByte();
        if (b == 40) {
            if (r.peekByte() == 41) {
                r.skip(1);
                return null;
            }
            ArrayList<IMAPAddress> v = new ArrayList<IMAPAddress>();
            do {
                IMAPAddress a;
                if ((a = new IMAPAddress(r)).isEndOfGroup()) continue;
                v.add(a);
            } while (r.peekByte() != 41);
            r.skip(1);
            return v.toArray(new InternetAddress[v.size()]);
        }
        if (b == 78 || b == 110) {
            r.skip(2);
            return null;
        }
        throw new ParsingException("ADDRESS parse error");
    }
}

