/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.imap.QueuedIMAPProtocol;
import com.sun.mail.imap.QueuingIMAPStore;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.mail.URLName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueuedIMAPProtocolWatcher {
    static final Logger LOG = LoggerFactory.getLogger(QueuedIMAPProtocolWatcher.class);
    private volatile ScheduledFuture<?> watcherFuture;
    final String lineSeparator = System.getProperty("line.separator");

    static boolean isEnabled() {
        return LOG.isDebugEnabled();
    }

    public void shutdown() {
        ScheduledFuture<?> tmp = this.watcherFuture;
        if (null != tmp) {
            tmp.cancel(false);
            this.watcherFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initWatcher(final ConcurrentMap<URLName, QueuingIMAPStore.CountingQueue> queues, ScheduledThreadPoolExecutor executor) {
        if (!QueuedIMAPProtocolWatcher.isEnabled()) {
            LOG.info(QueuedIMAPProtocolWatcher.class.getSimpleName() + " not initialized since configured log level does not imply DEBUG log level.");
            return;
        }
        ScheduledFuture<?> tmp = this.watcherFuture;
        if (null == tmp) {
            QueuedIMAPProtocolWatcher queuedIMAPProtocolWatcher = this;
            synchronized (queuedIMAPProtocolWatcher) {
                tmp = this.watcherFuture;
                if (null == tmp) {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            long minStamp = System.currentTimeMillis() - 30000L;
                            ConcurrentMap qs = queues;
                            String sep = QueuedIMAPProtocolWatcher.this.lineSeparator;
                            for (QueuingIMAPStore.CountingQueue q : qs.values()) {
                                ConcurrentMap<Thread, QueuingIMAPStore.ThreadTrace> trackedThreads = q.trackedThreads();
                                if (null == trackedThreads) continue;
                                for (Map.Entry entry : trackedThreads.entrySet()) {
                                    QueuingIMAPStore.ThreadTrace trace = (QueuingIMAPStore.ThreadTrace)entry.getValue();
                                    if (trace.protocol.isIdle() || trace.stamp >= minStamp) continue;
                                    long dur = System.currentTimeMillis() - trace.stamp;
                                    String msg = QueuedIMAPProtocolWatcher.formatThread((Thread)entry.getKey(), trace.protocol, q, dur, sep);
                                    q.getLogger().fine(msg);
                                    LOG.debug(msg);
                                }
                            }
                        }
                    };
                    this.watcherFuture = tmp = executor.scheduleWithFixedDelay(t, 10L, 10L, TimeUnit.SECONDS);
                    LOG.info(QueuedIMAPProtocolWatcher.class.getSimpleName() + " successfully initialized.");
                }
            }
        }
    }

    static String formatThread(Thread thread, QueuedIMAPProtocol protocol, QueuingIMAPStore.CountingQueue q, long dur, String lineSeparator) {
        StringBuilder sBuilder = new StringBuilder(8192);
        sBuilder.append("Thread \"").append(thread.getName()).append("\" holds ").append(protocol).append(" for ").append(dur).append("msec.").append(lineSeparator);
        sBuilder.append('(').append(q.getNewCount()).append(" in use for queue ").append(q.hashCode()).append(')').append(lineSeparator);
        StackTraceElement[] trace = thread.getStackTrace();
        sBuilder.append("    at ").append(trace[0]);
        for (int i = 1; i < trace.length; ++i) {
            sBuilder.append(lineSeparator).append("    at ").append(trace[i]);
        }
        return sBuilder.toString();
    }
}

