/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.QueuingIMAPStore;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.util.MailLogger;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import org.slf4j.Logger;

public class QueuedIMAPProtocol
extends IMAPProtocol
implements Comparable<QueuedIMAPProtocol> {
    private static final Logger LOG = QueuingIMAPStore.getLog();
    protected volatile QueuingIMAPStore store;
    private final QueuingIMAPStore.CountingQueue queue;
    private volatile long stamp;
    private String user;
    private boolean decrementPerformed;

    public QueuedIMAPProtocol(String name, String host, int port, Properties props, boolean isSSL, MailLogger logger, QueuingIMAPStore.CountingQueue q, QueuingIMAPStore store) throws IOException, ProtocolException {
        super(name, host, port, props, isSSL, logger);
        this.queue = q;
        this.store = store;
    }

    @Override
    public int compareTo(QueuedIMAPProtocol other) {
        long thisVal = this.stamp;
        long anotherVal = other.stamp;
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public boolean isIdle() {
        return null != this.idleTag;
    }

    public QueuedIMAPProtocol setStore(QueuingIMAPStore store) {
        this.store = store;
        return this;
    }

    public long getAuthenticatedStamp() {
        return this.stamp;
    }

    @Override
    protected void authenticatedStatusChanging(boolean authenticate, String u, String p) throws ProtocolException {
        if (authenticate) {
            this.user = u;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void disconnect() {
        try {
            super.disconnect();
        }
        finally {
            this.decrementNewCount();
        }
    }

    private synchronized void decrementNewCount() {
        QueuingIMAPStore.CountingQueue queue;
        if (!this.decrementPerformed && null != (queue = this.queue)) {
            queue.decrementNewCount();
            this.decrementPerformed = true;
            queue.removeTrackingInfo(this);
            if (this.logger.isLoggable(Level.FINE) || LOG.isDebugEnabled()) {
                String msg = "QueuedIMAPProtocol.disconnect(): Decremented new-count for " + this.toString() + "\n\t(total=" + queue.getNewCount() + ")";
                this.logger.fine(msg);
                LOG.debug(msg);
            }
        }
    }

    @Override
    public synchronized void logout() throws ProtocolException {
        this.stamp = System.currentTimeMillis();
        if (this.queue.offerIfAbsent(this)) {
            this.clearHandlers();
        } else {
            super.logout();
            if (this.logger.isLoggable(Level.FINE) || LOG.isDebugEnabled()) {
                String msg = "QueuedIMAPProtocol.logout(): Queue is full. LOGOUT for " + this.toString();
                this.logger.fine(msg);
                LOG.debug(msg);
            }
        }
        this.queue.removeTrackingInfo(this);
    }

    public synchronized void realLogout() throws ProtocolException {
        if (this.logger.isLoggable(Level.FINE) || LOG.isDebugEnabled()) {
            String msg = "QueuedIMAPProtocol.realLogout(): LOGOUT for " + this.toString();
            this.logger.fine(msg);
            LOG.debug(msg);
        }
        super.logout();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append(QueuedIMAPProtocol.class.getName()).append('@').append(this.hashCode());
        builder.append(" [");
        if (this.getHost() != null) {
            builder.append("host=").append(this.getHost()).append(", ");
        }
        builder.append("port=").append(this.getPort());
        if (null != this.user) {
            builder.append(", ").append("user=").append(this.user);
        }
        builder.append("]");
        return builder.toString();
    }
}

