/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.util.MailLogger;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.mail.URLName;

public class CountingIMAPProtocol
extends IMAPProtocol {
    private static final ConcurrentMap<URLName, AtomicInteger> COUNTERS = new ConcurrentHashMap<URLName, AtomicInteger>(16, 0.9f, 1);
    private volatile AtomicInteger counter;
    private String user;

    private static AtomicInteger initCounter(URLName url) {
        AtomicInteger ns;
        AtomicInteger s = (AtomicInteger)COUNTERS.get(url);
        if (null == s && null == (s = COUNTERS.putIfAbsent(url, ns = new AtomicInteger(0)))) {
            s = ns;
        }
        return s;
    }

    public CountingIMAPProtocol(String name, String host, int port, Properties props, boolean isSSL, MailLogger logger) throws IOException, ProtocolException {
        super(name, host, port, props, isSSL, logger);
    }

    @Override
    protected void authenticatedStatusChanging(boolean authenticate, String u, String p) throws ProtocolException {
        if (authenticate) {
            this.user = u;
            this.increment(u, p);
        } else {
            this.decrement();
        }
    }

    protected void increment(String u, String p) {
        AtomicInteger counter = this.counter;
        if (null == counter) {
            this.counter = counter = CountingIMAPProtocol.initCounter(new URLName("imap", this.host, this.port, null, u, p));
        }
        if (null != counter && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this + " - " + counter.incrementAndGet());
        }
    }

    protected void decrement() {
        AtomicInteger counter = this.counter;
        if (null != counter) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(this + " - " + counter.decrementAndGet());
            }
            this.counter = null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append(CountingIMAPProtocol.class.getName()).append('@').append(this.hashCode());
        builder.append(" [");
        if (this.getHost() != null) {
            builder.append("host=").append(this.getHost()).append(", ");
        }
        builder.append("port=").append(this.getPort());
        if (null != this.user) {
            builder.append(", ").append("user=").append(this.user);
        }
        builder.append("]");
        return builder.toString();
    }
}

