/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.util.MailLogger;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;

public class IdleManager {
    private Executor es;
    private Selector selector;
    private MailLogger logger;
    private volatile boolean die = false;
    private Queue<IMAPFolder> toWatch = new ConcurrentLinkedQueue<IMAPFolder>();
    private Queue<IMAPFolder> toAbort = new ConcurrentLinkedQueue<IMAPFolder>();

    public IdleManager(Session session, Executor es) throws IOException {
        this.logger = new MailLogger(this.getClass(), "DEBUG IMAP", session);
        this.es = es;
        this.selector = Selector.open();
        es.execute(new Runnable(){

            @Override
            public void run() {
                IdleManager.this.select();
            }
        });
    }

    public synchronized void watch(Folder folder) throws IOException, MessagingException {
        if (!(folder instanceof IMAPFolder)) {
            throw new MessagingException("Can only watch IMAP folders");
        }
        IMAPFolder ifolder = (IMAPFolder)folder;
        SocketChannel sc = ifolder.getChannel();
        if (sc == null) {
            throw new MessagingException("Folder is not using SocketChannels");
        }
        this.logger.log(Level.FINEST, "IdleManager watching {0}", ifolder);
        ifolder.startIdle(this);
        this.toWatch.add(ifolder);
        this.selector.wakeup();
    }

    synchronized void requestAbort(IMAPFolder folder) {
        this.toAbort.add(folder);
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void select() {
        this.die = false;
        try {
            while (!this.die) {
                this.watchAll();
                this.logger.finest("IdleManager waiting...");
                int ns = this.selector.select();
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "IdleManager selected {0} channels", ns);
                }
                if (this.die) break;
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
                while (this.processKeys() && this.selector.selectNow() > 0) {
                }
            }
        }
        catch (InterruptedIOException ex) {
            this.logger.log(Level.FINE, "IdleManager interrupted", ex);
        }
        catch (IOException ex) {
            this.logger.log(Level.FINE, "IdleManager got exception", ex);
        }
        finally {
            try {
                this.unwatchAll();
                this.selector.close();
            }
            catch (IOException ex2) {}
            this.logger.fine("IdleManager exiting");
        }
    }

    private void watchAll() {
        IMAPFolder folder;
        while ((folder = this.toWatch.poll()) != null) {
            this.logger.log(Level.FINEST, "IdleManager adding {0} to selector", folder);
            SocketChannel sc = folder.getChannel();
            if (sc == null) continue;
            try {
                sc.configureBlocking(false);
                sc.register(this.selector, 1, folder);
            }
            catch (IOException ex) {
                this.logger.log(Level.FINEST, "IdleManager can't register folder", ex);
            }
        }
    }

    private boolean processKeys() throws IOException {
        IMAPFolder folder;
        boolean more = false;
        while ((folder = this.toAbort.poll()) != null) {
            this.logger.log(Level.FINE, "IdleManager aborting IDLE for folder: {0}", folder);
            SocketChannel sc = folder.getChannel();
            if (sc == null) continue;
            SelectionKey sk = sc.keyFor(this.selector);
            if (sk != null) {
                sk.cancel();
            }
            sc.configureBlocking(true);
            folder.idleAbort();
            this.toWatch.add(folder);
            more = true;
        }
        Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
        for (SelectionKey sk : selectedKeys) {
            selectedKeys.remove(sk);
            sk.cancel();
            folder = (IMAPFolder)sk.attachment();
            this.logger.log(Level.FINE, "IdleManager selected folder: {0}", folder);
            SelectableChannel sc = sk.channel();
            sc.configureBlocking(true);
            try {
                if (folder.handleIdle(false)) {
                    this.toWatch.add(folder);
                    more = true;
                    continue;
                }
                this.logger.log(Level.FINE, "IdleManager done watching folder {0}", folder);
            }
            catch (MessagingException ex) {
                this.logger.log(Level.FINE, "IdleManager got exception for folder: " + folder, ex);
            }
        }
        return more;
    }

    private void unwatchAll() {
        Set<SelectionKey> keys = this.selector.keys();
        for (SelectionKey sk : keys) {
            sk.cancel();
            IMAPFolder folder = (IMAPFolder)sk.attachment();
            this.logger.log(Level.FINE, "IdleManager no longer watching folder: {0}", folder);
            SelectableChannel sc = sk.channel();
            try {
                sc.configureBlocking(true);
            }
            catch (IOException ex) {}
        }
    }

    public synchronized void stop() {
        this.die = true;
        this.logger.finest("IdleManager stopping");
        this.selector.wakeup();
    }
}

