/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.iap;

import com.sun.mail.iap.AString;
import com.sun.mail.iap.Atom;
import com.sun.mail.iap.Literal;
import com.sun.mail.iap.LiteralException;
import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.util.ASCIIUtility;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class Argument {
    protected ArrayList<Object> items = new ArrayList(1);
    private static final char[] UPPER_NIL = new char[]{'N', 'I', 'L'};
    private static final char[] LOWER_NIL = new char[]{'n', 'i', 'l'};

    public void append(Argument arg) {
        this.items.ensureCapacity(this.items.size() + arg.items.size());
        for (int i = 0; i < arg.items.size(); ++i) {
            this.items.add(arg.items.get(i));
        }
    }

    public void writeString(String s) {
        this.items.add(new AString(ASCIIUtility.getBytes(s)));
    }

    public void writeString(String s, String charset) throws UnsupportedEncodingException {
        if (charset == null) {
            this.writeString(s);
        } else {
            this.items.add(new AString(s.getBytes(charset)));
        }
    }

    public void writeBytes(byte[] b) {
        this.items.add(b);
    }

    public void writeBytes(ByteArrayOutputStream b) {
        this.items.add(b);
    }

    public void writeBytes(Literal b) {
        this.items.add(b);
    }

    public void writeAtom(String s) {
        this.items.add(new Atom(s));
    }

    public void writeNumber(int i) {
        this.items.add(i);
    }

    public void writeNumber(long i) {
        this.items.add(i);
    }

    public void writeArgument(Argument c) {
        this.items.add(c);
    }

    public void write(Protocol protocol) throws IOException, ProtocolException {
        int size = this.items != null ? this.items.size() : 0;
        DataOutputStream os = (DataOutputStream)protocol.getOutputStream();
        for (int i = 0; i < size; ++i) {
            Object o;
            if (i > 0) {
                os.write(32);
            }
            if ((o = this.items.get(i)) instanceof Atom) {
                os.writeBytes(((Atom)o).string);
                continue;
            }
            if (o instanceof Number) {
                os.writeBytes(((Number)o).toString());
                continue;
            }
            if (o instanceof AString) {
                this.astring(((AString)o).bytes, protocol);
                continue;
            }
            if (o instanceof byte[]) {
                this.literal((byte[])o, protocol);
                continue;
            }
            if (o instanceof ByteArrayOutputStream) {
                this.literal((ByteArrayOutputStream)o, protocol);
                continue;
            }
            if (o instanceof Literal) {
                this.literal((Literal)o, protocol);
                continue;
            }
            if (!(o instanceof Argument)) continue;
            os.write(40);
            ((Argument)o).write(protocol);
            os.write(41);
        }
    }

    private static boolean isNIL(byte[] bytes) {
        int len = bytes.length;
        if (len != UPPER_NIL.length) {
            return false;
        }
        boolean matches = true;
        for (int i = 0; matches && i < len; ++i) {
            byte b = bytes[i];
            matches = b == (byte)UPPER_NIL[i] || b == (byte)LOWER_NIL[i];
        }
        return matches;
    }

    private void astring(byte[] bytes, Protocol protocol) throws IOException, ProtocolException {
        byte b;
        int i;
        DataOutputStream os = (DataOutputStream)protocol.getOutputStream();
        int len = bytes.length;
        if (len > 1024) {
            this.literal(bytes, protocol);
            return;
        }
        boolean quote = len == 0;
        boolean escape = false;
        if (Argument.isNIL(bytes)) {
            quote = true;
        }
        for (i = 0; i < len; ++i) {
            b = bytes[i];
            if (b == 0 || b == 13 || b == 10 || (b & 0xFF) > 127) {
                this.literal(bytes, protocol);
                return;
            }
            if (b != 42 && b != 37 && b != 40 && b != 41 && b != 123 && b != 34 && b != 92 && (b & 0xFF) > 32) continue;
            quote = true;
            if (b != 34 && b != 92) continue;
            escape = true;
        }
        if (quote) {
            os.write(34);
        }
        if (escape) {
            for (i = 0; i < len; ++i) {
                b = bytes[i];
                if (b == 34 || b == 92) {
                    os.write(92);
                }
                os.write(b);
            }
        } else {
            os.write(bytes);
        }
        if (quote) {
            os.write(34);
        }
    }

    private void literal(byte[] b, Protocol protocol) throws IOException, ProtocolException {
        this.startLiteral(protocol, b.length).write(b);
    }

    private void literal(ByteArrayOutputStream b, Protocol protocol) throws IOException, ProtocolException {
        b.writeTo(this.startLiteral(protocol, b.size()));
    }

    private void literal(Literal b, Protocol protocol) throws IOException, ProtocolException {
        b.writeTo(this.startLiteral(protocol, b.size()));
    }

    private OutputStream startLiteral(Protocol protocol, int size) throws IOException, ProtocolException {
        DataOutputStream os = (DataOutputStream)protocol.getOutputStream();
        boolean nonSync = protocol.supportsNonSyncLiterals();
        os.write(123);
        os.writeBytes(Integer.toString(size));
        if (nonSync) {
            os.writeBytes("+}\r\n");
        } else {
            os.writeBytes("}\r\n");
        }
        os.flush();
        if (!nonSync) {
            Response r;
            while (!(r = protocol.readResponse()).isContinuation()) {
                if (!r.isTagged()) continue;
                throw new LiteralException(r);
            }
        }
        return os;
    }
}

