/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import java.util.ArrayList;

public class UIDSet {
    public long start;
    public long end;

    public UIDSet() {
    }

    public UIDSet(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long size() {
        return this.end - this.start + 1L;
    }

    public static UIDSet[] createUIDSets(long[] msgs) {
        ArrayList<UIDSet> v = new ArrayList<UIDSet>(msgs.length);
        for (int i = 0; i < msgs.length; ++i) {
            int j;
            UIDSet ms = new UIDSet();
            ms.start = msgs[i];
            for (j = i + 1; j < msgs.length && msgs[j] == msgs[j - 1] + 1L; ++j) {
            }
            ms.end = msgs[j - 1];
            v.add(ms);
            i = j - 1;
        }
        return v.toArray(new UIDSet[v.size()]);
    }

    public static String toString(UIDSet[] msgsets) {
        if (msgsets == null || msgsets.length == 0) {
            return null;
        }
        int i = 0;
        StringBuilder s = new StringBuilder();
        int size = msgsets.length;
        while (true) {
            long start;
            long end;
            if ((end = msgsets[i].end) > (start = msgsets[i].start)) {
                s.append(start).append(':').append(end);
            } else {
                s.append(start);
            }
            if (++i >= size) break;
            s.append(',');
        }
        return s.toString();
    }

    public static long size(UIDSet[] msgsets) {
        long count = 0L;
        if (msgsets == null) {
            return 0L;
        }
        for (int i = 0; i < msgsets.length; ++i) {
            count += msgsets[i].size();
        }
        return count;
    }
}

