/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.mobilepush.events.mail.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import com.openexchange.mobilepush.MobilePushProvider;
import com.openexchange.mobilepush.events.MobilePushEvent;

/**
 * {@link MobilePushMailEvent}
 *
 * @author <a href="mailto:lars.hoogestraat@open-xchange.com">Lars Hoogestraat</a>
 */
public class MobilePushMailEvent implements MobilePushEvent {

    private final int userId;

    private final int contextId;

    private final Map<String, Object> messageData;

    private String collapseKey;

    private final static MobilePushProvider PROVIDER = MobilePushProvider.MAIL;

    /**
     * Initializes a new {@link MobilePushMailEvent}.
     */
    public MobilePushMailEvent(int contextId, int userId, Map<String, Object> messageData) {
        super();
        this.userId = userId;
        this.contextId = contextId;
        this.messageData = messageData;
    }

    @Override
    public Map<String, Object> getMessageData() {
        return messageData;
    }

    @Override
    public int getUserId() {
        return userId;
    }

    @Override
    public int getContextId() {
        return contextId;
    }

    @Override
    public MobilePushProvider getProvider() {
        return PROVIDER;
    }

    @Override
    public String getCollapseKey() {
        return collapseKey;
    }

    @Override
    public void setCollapseKey(String collapseKey) {
        this.collapseKey = collapseKey;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<Entry<String, Object>> iter = messageData.entrySet().iterator();
        while (iter.hasNext()) {
            Entry<String, Object> entry = iter.next();
            sb.append(entry.getKey());
            sb.append('=').append('"');
            sb.append(entry.getValue());
            sb.append('"');
            if (iter.hasNext()) {
                sb.append(',').append(' ');
            }
        }
        return "MobilePushMailEvent [userId=" + userId + ", contextId=" + contextId + ", "
            + "messageData=" + sb.toString() + "]";
    }
}
