/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/oxguard_core', ['settings!io.ox/mail', 'oxguard/core/og_http'],
                                function (settings, og_http) {
    'use strict';
    
    // Add lock to the message detail view and menu options
    
    // Prompt for creating master keys for this user if not yet created.
    function createKeys(errors, view) {
        var def = $.Deferred();
        require (['io.ox/core/notifications', 'io.ox/core/tk/dialogs', 'gettext!oxguard/oxguard_core'], function (notify, dialogs, gt) {
            
            var dialog = new dialogs.CreateDialog({ width: 450, center: true, enter : 'ok'});
            dialog.header($('<h4>').text(gt('Create Guard Security Keys')));
            var explain = $('<div><p>' + gt('This appears to be the first time you have used Encryption') + '</p><p>' + gt('Please enter a password to protect your new encrypted items') + '</p>');
            
            var passdiv = $('<div>').addClass('row-fluid');
            var table = $('<table class="og_password_prompt"/>')
            .append('<tr><td class="pw"><em>' + gt('Password') + ':</em></td><td><input name="newogpassword" type="password"/></td></tr>')
            .append('<tr><td class="pw"><em>' + gt('Confirm') + ':</em></td><td><input name="newogpassword2" type="password"/></td></tr>');
            passdiv.append(table);
            var rule = $('<hr style="padding:10px;"/>');
            var recovery = $('<p>' + gt('Please enter a secondary email address in case you need to reset your password' + '</p>'));

            var table2 = $('<table class="og_password_prompt"/>');
            var row = $('<tr><td class="pw"><em>' + gt ('Email:') + '</em></td><td><input name="recoveryemail"/></td></tr>');
            table2.append(row);
            dialog.getBody().append(explain).append(passdiv).append(rule).append(recovery).append(table2);

            if (errors !== undefined) {
                dialog.getBody().append('<div><span style="color: red;">' + errors + '</span></div>');
            }
            dialog
            .addPrimaryButton('ok', gt('OK'), 'ok')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('cancel', function () {
                def.reject('cancel');
            })
            .on('ok', function () {
                var pass1 = $('input[name="newogpassword"]').val();
                var pass2 = $('input[name="newogpassword2"]').val();
                if (pass1 !== pass2) {
                    createKeys(gt('Passwords not equal'), view);
                    return;
                }
                var emailaddr = $('input[name="recoveryemail"]').val();
                if ((emailaddr.length > 1) && (!validateEmail(emailaddr))) {
                    createKeys(gt('Enter new secondary Email address'), view);
                    return;
                }
                var userdata = {
                        user_id : ox.user_id,
                        password : pass1,
                        sessionID : ox.session,
                        language : ox.language,
                        cid : ox.context_id,
                        email : emailaddr
                    };
                var waitdiv = $('<div class="og_wait" id="keygen"></div');
                waitdiv.append('<i class="fa-key fa icon-key fa-spin icon-spin"/><span>' + gt('Generating key, Please wait') + '</span>');
                $('.window-container-center').append(waitdiv);
                waitdiv.show();
                og_http.post(ox.apiRoot + '/oxguard/login?action=create', '&session=' + ox.session, userdata)
                .done(function (data) {
                    $('.og_wait').hide();
                    if (data.indexOf('ok') > 0) {
                        window.oxguarddata.passcode = null;
                        def.resolve('OK');
                    } else {
                        $('.og_wait').hide();
                        notify.yell('error', gt('Problems creating keys, please try again later'));
                        def.reject('error');
                    }
                    
                })
                .fail(function (data) {
                    $('.og_wait').hide();
                    if (data.responseText.trim() === 'Existing') {
                        notify.yell('error', gt('Problems creating keys.  Keys already exist for this email address in another account'));
                    } else
                    notify.yell('error', gt('Problems creating keys, please try again later'));
                    def.reject('error');
                });
                
            })
            .show(function () {  // Normalize the two tables to have same column size
                $('input[name="ogname"]').focus();
                window.setTimeout(function () {
                    var j = 0;
                    $('.pw').each(function(i,v) { 
                        var w = $(v).width();
                        if (w > j) j = w;
                        });
                    $('.pw').each(function(i,v) {
                        $(v).width(j);
                    });
                    var email = $('input[name="recoveryemail"]'); // Watch email entry for valid
                    email.on('keyup', function () {
                        if (validateEmail(email.val())) {
                            email.css('background-color', 'white');
                        } else {
                            email.css('background-color', 'rgb(253, 187, 179)');
                        }
                    });
                },0);
            });
        });
        return (def);
    }
    
    function validateEmail(email) { 
        var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    } 


    return {
        
            // Send authorization to the oxguard server
        auth: function authorize(userid, password, extra)
            {
            var def = $.Deferred();
            var defaultSendAddress = $.trim(settings.get('defaultSendAddress', ''));
            var userdata = {
                    user_id : userid,
                    ox_password : password,
                    encr_password : '',
                    sessionID : ox.session,
                    lang: ox.language,
                    cid : ox.context_id,
                    email : defaultSendAddress,
                    extrapass : extra ? extra : ''
                };
            var url = ox.apiRoot + '/oxguard/login?action=login';
            var params = '&session=' + ox.session + '&time=' + new Date().getTime();
            og_http.post (url, params, userdata)
            .done (function (data) {
                def.resolve(data);
            })
            .fail(function () {
                def.reject();
            });
            return def;
            
        },
        
        createKeys : createKeys,
        validateEmail : validateEmail
    };
});
    

    