/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/mail/oxguard_mail_write_core', ['io.ox/core/extensions', 'oxguard/core/og_http',
                                'io.ox/core/notifications',
                                'io.ox/core/tk/dialogs', 'gettext!oxguard/oxguard_core'],
                                function (ext, og_http, notify, dialogs, gt) {
    'use strict';
    
    // Add lock to the message detail view and menu options
    var lockclass = 'icon-lock icon-2x fa fa-lock fa-2x oxguard_lock';
    var unlockclass = 'icon-unlock icon-2x fa fa-unlock fa-2x oxguard_lock';
    
    
    // Save encryption settings to header
    function saveToHeader(view) {
        try {
            var emailheader = view.find('[name="headers"]');
            var headerstring = emailheader.val();
            var header = {};
            if (headerstring !== '') header = JSON.parse(headerstring);
            var guard = (view.find('#OxGuardOn:checked').length > 0);
            header['X-OxGuard'] =  guard ? 'True' : 'False';
            if (guard) {
                header['X-OxGuard-Expiration'] = getExpDate(view);
                header['X-OxGuard-ExtraPass'] = getPassword(view);
                if ((window.oxguarddata.temp !== null) && (window.oxguarddata.temp !== undefined)) {
                    if (window.oxguarddata.temp.ogId !== undefined) {
                        header['X-OxGuard-ReplyId'] = window.oxguarddata.temp.ogId;
                    }
                } 
            } else {
                delete header['X-OxGuard-Expiration'];
                delete header['X-OxGuard-ExtraPass'];
            }
            emailheader.val(JSON.stringify(header));
        } catch (e) {
            console.log(e);
        }

        return;
    }
    

    
    // Create the options div for oxguard
 

    // Get the expiration date
    function getExpDate(view)
    {
        return (view.find('#expdatepicker').val());
    }
      

    // Get the password assigned
    function getPassword(view)
    {
        var password = '';//If blank, use oxtest
        if (view.find('#reqpassword').is(':checked')) {
            password = view.find('#passbox').val();
        }
        return (password);
    }
    
    
    // Check if email has a public key that we can use
    function checkrecip(email, from, view) {
        if (email.val().indexOf('<') < 0) return;// make sure has email address
        var id = hash(email.val());
        if (view.find('#recip_' + id).length === 1) {
            return;// If we have already processed, return
        }
        var tag = $('<span class="oxguard_key icon-stack fa-stack" id="recip_' + id + '"></span>');
        email.before(tag);// Tag this recipient
        var params = '&email=' + email.val() + '&cid=' + ox.context_id + '&from=' + encodeURIComponent(from);
        og_http.get(ox.apiRoot + '/oxguard/mail?action=getkey', params)
        .done(function (data) {//Get the key
            try {
                if (data.publicKey === undefined) {
                   // tag.append('<img src="apps/oxguard/images/nokey.png" title="' + gt('Unable to get key for encryption') + '"/>');
                    tag.append('<i class="icon-ban-circle icon-stack-base fa fa-ban fa-stack-2x" style="color:red;"/><i class="icon-key fa fa-key fa-stack-1x" title="' + gt('Unable to get key for encryption') + '"/>');
                    return;
                }
                if (data.publicKey.length > 20) {
                    if (data.guest === 'false') {
                        tag.append('<i class="icon-key fa fa-key oxguard_lock" title="' + gt('Recipient has Guard') + '"/>');
                      //  tag.append('<img src="apps/oxguard/images/key32.png" title="' + gt('Recipient has Guard') + '"/>');
                    } else {
                       // tag.append('<img src="apps/oxguard/images/key32-out.png" title="' + gt('Using a Guest account for Guard') + '"/>');
                        //#. Displayed over icon in name to symbolize that a guest account is created for the recipient
                        tag.append('<i class="icon-male icon-stack-base fa fa-male fa-stack-2x" style="color:#cfc;"/><i class="icon-key fa fa-key fa-stack-1x oxguard_lock" title="' + gt('Using a guest account for email') + '"/>');
                    }
                    
                } else {
                   // tag.append('<img src="apps/oxguard/images/nokey.png" title="' + gt('Unable to get key for encryption') + '"/>');
                    if (data.guest === 'true') {
                        tag.append('<i id="newguest" class="icon-male icon-stack-base fa fa-male fa-stack-2x" style="color:#fcc;"/><i class="icon-key fa fa-key fa-stack-1x oxguard_lock" title="' + gt('Will create new guest account for Guard') + '"/>');
                        var em = email.val().replace(/"/g, '');
                        tag.append('<input type="hidden" name="newguest" class="og_new" value="' + em + '"/>');
                    } else {
                        tag.append('<i class="icon-ban-circle icon-stack-base fa fa-ban fa-stack-2x" style="color:red;"/><i class="icon-key fa fa-key fa-stack-1x" title="' + gt('Unable to create Guard account, please try again later') + '"/>');
                    }
                    
                }
            } catch (e) {
                console.log(e);
            }
        });
        
    }
    
    // Return a has of string
    function hash(str) {
        var hashed = 0;
        if (str.length === 0) return hashed;
        for (var i = 0; i < str.length; i++) {
            hashed = (31 * hashed + str.charCodeAt(i)) << 0;
        }
        return hashed;
    }
    
    function validateEmail(email) {
        var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }
    
    // Prompt for creating master keys for this user if not yet created.
    function createKeys(errors, view) {
        var dialog = new dialogs.CreateDialog({ width: 450, center: true, enter : 'ok'});
        dialog.header($('<h4>').text(gt('Create Guard Account')));
        var explain = $('<div><p>' + gt('This appears to be the first time you have used Guard') + '</p><p>' + gt('Please enter a password to protect your Guard account') + '</p>');
        
        var passdiv = $('<div>').addClass('row-fluid');
        // Create password prompt table
        var table = $('<table class="og_password_prompt"/>');
        var row = $('<tr/>');
        row.append('<td style="width: 100px;"><em>' + gt('Password') + ':</em></td>');
        var col = $('<td/>');
        var new1 = $('<input name="newogpassword" type="password"/>');
        row.append(col.append(new1));
        var row2 = $('<tr/>');
        row2.append('<td><em>' + gt('Confirm') + ':</em></td>');
        var col2 = $('<td/>');
        var new2 = $('<input name="newogpassword2" type="password"/>');
        row2.append(col2.append(new2));
        table.append(row).append(row2);
        passdiv.append(table);
        // Routine to check if passwords equal, highlight if not
        new2.keyup(function () {
            if (new1.val() !== new2.val()) {
                new2.css('background-color', 'salmon');
                $('button[data-action="okx"]').prop('disabled', true);
            } else {
                new2.css('background-color', 'white');
                $('button[data-action="okx"]').prop('disabled', false);
            }
        });
        dialog.getBody().append(explain).append(passdiv);
        var resetpass = $('<div style="margin-top:10px;"><p>' + gt('Please enter a secondary email address in case you need to reset your password.  A new password would be sent to this email.') +
                '</p></div>');
        var resetEmail = $('<table class="og_password_prompt"><tr><td style="width: 100px;"><em>' + gt('Email:') + '</em></td><td><input name="resetemail"/></td></tr></table>');
        dialog.getBody().append(resetpass).append(resetEmail);
        if (errors !== undefined) {
            dialog.getBody().append('<div><span style="color: red;">' + errors + '</span></div>');
        }
        dialog
        .addPrimaryButton('ok', gt('OK'), 'ok')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('cancel', function () {
            unlock(view);
        })
        .on('ok', function () {
            var pass1 = $('input[name="newogpassword"]').val();
            var pass2 = $('input[name="newogpassword2"]').val();
            if (pass1 !== pass2) {
                createKeys(gt('Passwords not equal'), view);
                return;
            }
            var remail = $('input[name="resetemail"]').val();
            var userdata = {
                    user_id : ox.user_id,
                    password : pass1,
                    sessionID : ox.session,
                    language : ox.language,
                    cid : ox.context_id
                };
            if ((remail.length > 1) && (!validateEmail(remail))) {
                createKeys(gt('Enter new secondary Email address'), view);
                return;
            }
            if (validateEmail(remail)) userdata.email = remail;
            var waitdiv = $('<div class="og_wait" id="keygen"></div');
            waitdiv.append('<i class="fa-key icon-key fa fa-spin icon-spin"/><span>' + gt('Initializing Guard, please wait') + '</span>');
            $('.window-container-center').append(waitdiv);
            waitdiv.show();
            og_http.post(ox.apiRoot + '/oxguard/login?action=create', '&session=' + ox.session, userdata)
            .done(function (data) {
                $('.og_wait').hide();
                if (data.indexOf('ok') > 0) {
                    window.oxguarddata.passcode = null;
                    checkrecipient(view);
                } else {
                    $('.og_wait').hide();
                    notify.yell('error', gt('Problems creating keys, please try again later'));
                    unlock(view);
                }
                
            })
            .fail(function (data) {
                $('.og_wait').hide();
                if (data.responseText.trim() === 'Existing') {
                    notify.yell('error', gt('Problems creating keys.  Keys already exist for this email address in another account'));
                } else
                notify.yell('error', gt('Problems creating keys, please try again later'));
                unlock(view);
            });
            
        })
        .show(function () { 
            $('input[name="ogname"]').focus(); 
            $('input[name="resetemail"]').on('keyup', function (e) {
                var email = $(e.target);
                if (validateEmail(email.val())) {
                    email.css('background-color', 'white');
                } else {
                    email.css('background-color', 'rgb(253, 187, 179)');
                }
            });
            });
    }
    
    
    function checkrecipient(view) {
        if (window.oxguarddata.passcode === 'No Key') {
            createKeys('', view);
            return;// Do not check recipients until the master key is created (in case mailing to self)
        }
        var from = view.find('.sender-dropdown').val();
        view.find('input[name="to"]').each(function () {
            checkrecip($(this), from, view);
        });
        view.find('input[name="cc"]').each(function () {
            checkrecip($(this), from, view);
        });
        view.find('input[name="bcc"]').each(function () {
            checkrecip($(this), from, view);
        });

    }
    
    function unlock(view) {
        view.find('#statuslock').attr('class', unlockclass);
        view.find('#statuslock').attr('title', gt('Click to enable encryption'));
        if (_.device('smartphone')) {
            $('.btn-primary:visible').html(gt('Send'));
        } else {
            view.find('.btn-primary:visible').html(gt('Send'));
        }
        view.find('#OxGuardOn').prop('checked', false);
        saveToHeader(view);
        view.find('.oxguard_key').hide();
    }
    
    function lock(view, baton) {
        if (baton) {
            if (baton.app.autosave) {
                window.clearTimeout(baton.app.autosave.timer);
            } 
        }
        view.find('#statuslock').attr('class', lockclass);
        view.find('#statuslock').attr('title', gt('Click to disable encryption'));
        if (_.device('smartphone')) {
            $('.btn-primary:visible').html(gt('Send Secure'));
        } else {
            view.find('.btn-primary:visible').html(gt('Send Secure'));
        }
        view.find('#OxGuardOn').prop('checked', true);
        checkrecipient(view);
        view.find('.oxguard_key').show();
        saveToHeader(view);
    }
    
   


    return {
        
        checkRecip : function (view) {
            
            checkrecipient(view);
            
        },

        updateheader : function updateHeader(view) {
            saveToHeader(view);
        },
        
        lock : lock,
        unlock : unlock,
        createKeys : createKeys,
        saveToHeader : saveToHeader
        
    
    };
});
    

    