/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */

define('oxguard/mail/options', ['oxguard/mail/oxguard_mail_write_core', 'gettext!oxguard/mail/options'],
                              function (core, gt) {
    
    var lockclass = 'icon-lock icon-2x fa fa-lock fa-2x oxguard_lock';
    var unlockclass = 'icon-unlock icon-2x fa fa-unlock fa-2x oxguard_lock';
    
    // Retrieve oxguard settings from header and repopulate
    function retrieveOxGuard(view, baton)
    {
        var headerstring = view.find('[name="headers"]').val();
        // Make sure header string exists and populated
        if (typeof headerstring !== 'undefined') {
            if (headerstring.length > 1) {
                var header = JSON.parse(headerstring);
                // Set oxguard on
                window.setTimeout(function () {
                    if (typeof header['X-OxGuard'] !== 'undefined') {
                        if (header['X-OxGuard'] === 'True') {
                                core.lock(view, baton);
                                core.checkRecip(view); 
                        }
                        // Expiration Date
                        view.find('#expdatepicker').val(header['X-OxGuard-Expiration']);
                        // Get access restrictions
                    }
                    if (typeof header['X-OxGuard-ExtraPass'] !== 'undefined') {
                        view.find('#passbox').val(header['X-OxGuard-ExtraPass']);
                        if (header['X-OxGuard-ExtraPass'].trim() !== '') {
                            view.find('#reqpassword').prop('checked', 'true');
                            view.find('#passbox').parent().show();
                        }
                    }
                    if (typeof header['X-OxGuard-Draft'] !== 'undefined') {
                        if (baton) baton.app.refId = header['X-OxGuard-Draft'];
                    }
                }, 500);
            }
            
        }

    }
    
    function createlock(view, baton) {
        
        view.find('.subject-wrapper').css('right', '40px').css('position', 'absolute'); // Shift subject line over
        view.find('.priority-overlay').css('right', '53px');
        var lockstatus = $('<div id="lockdiv" style="float:right;"><i id="statuslock" class="' + unlockclass + '" title="' + gt('Click to enable encryption') + '"></div>');
        var subjectline = view.find('.subject-wrapper');
        subjectline.after(lockstatus);
        lockstatus.click(function () {
            if (view.find('#OxGuardOn').is(':checked') === true) {
                core.unlock(view);
            } else {
                core.lock(view, baton);
            }
        });
    }
    
    function createExtraPasswordPrompt(view) {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 450, height: 300, center: true});
            dialog.header($('<h4>').text(gt('Extra Password')));
            var passdiv = $('<div>').addClass('row-fluid');
            passdiv.append('<p>' + gt('This allows you to set an extra password that will be required for reading this item.') + '</p><p>' + gt('Please enter it below') + '</p>');
            var table = $('<table>');
            var row1 = $('<tr>');
            row1.append('<td><span>' + gt('Password') + ':</span></td>');
            var password1 = $('<input id="extrapassword1" type="password" class="oxguard_extrapass"/>');
            var pstd = $('<td>').append(password1);
            row1.append(pstd);
            var row2 = $('<tr>');
            
            row2.append('<td><span>' + gt('Confirm') + ': </span></td>');
            var password2 = $('<input id="extrapassword2" type="password" class="oxguard_extrapass" style="top:130px;"/>');
            var eptd = $('<td>').append(password2);
            row2.append(eptd);
            table.append(row1).append(row2);
            passdiv.append(table);
            password1.keyup(function () {
                if (password1.val() !== password2.val()) {
                    $('button[data-action="okx"]').prop('disabled', true);// disable the ok button if not same
                } else {
                    $('button[data-action="okx"]').prop('disabled', false);
                }
            });
            password2.keyup(function () {
                if (password1.val() !== password2.val()) {
                    password2.css('background-color', 'salmon');
                    $('button[data-action="okx"]').prop('disabled', true);
                } else {
                    password2.css('background-color', 'white');
                    $('button[data-action="okx"]').prop('disabled', false);
                }
            });
            dialog.getBody().append(passdiv);
            dialog
            .addPrimaryButton('ok', gt('OK'), 'okx')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('ok', function () {
                if ($('#extrapassword1').val() !== $('#extrapassword2').val()) {
                    $('#reqpassword').attr('checked', false);
                    view.find('#passbox').val('');
                } else {
                    var extrap = password1.val();
                    if (extrap === '') {
                        $('#reqpassword').attr('checked', false);
                    } else {
                        require(['oxguard/crypto/encr'], function (encr) {
                            var encrypted = encr.cryptPass(extrap);
                            if (encrypted !== null) {
                                view.find('#passbox').val('E!' + encrypted);
                            } else view.find('#passbox').val(extrap);
                            core.saveToHeader(view);
                            return;
                        });
                    }
                }
                core.saveToHeader(view);
            })
            .on('cancel', function () {
                $('#reqpassword').attr('checked', false);
            })
            .show(function () {
                $('#extrapassword1').focus();
                password1.val('');
                password2.val('');
            });
        });
        
    }
    
    function createOptions(view, baton) {
        
        // Lets see if we should allow user to see OxGuard compose
        if ((window.oxguarddata.settings.oxguard === false) || (window.oxguarddata.settings.oxguard === undefined)) {
            if (window.oxguarddata.action !== 'secureReply') {// OK if secure reply, otherwise
                var headerstring = view.find('[name="headers"]').val();// Check for OG header
                // Make sure header string exists and populated
                if (typeof headerstring !== 'undefined') {
                    if (headerstring.length > 1) {
                        var header = JSON.parse(headerstring);
                        // If oxguard didn't update header, then return
                        if (typeof header['X-OxGuard'] === 'undefined') {
                            return;
                        }
                    } else return;
                } else return;
            }
        }
        if (window.oxguarddata.action === 'sendfile') {// If it is going to be sending already encrypted file, then don't add encryption options
            window.oxguarddata.action = null;
            return;
        }
        if (window.oxguarddata.sentfolder === undefined) {// Get sent folder data for sending
            require(['settings!io.ox/mail']).done(function (settings) {
                window.oxguarddata.sentfolder = settings.get('folder/sent');
                window.oxguarddata.draftfolder = settings.get('folder/drafts');
            });
        }
        createlock(view, baton);
        // div seperator for each item
        var sectiondiv = '<div class="section-item oxguard_options" style="padding-top: 0.1em; padding-bottom: 0.2em; line-height: 2em;">';
        // Enabled and disabled buttons
        var oxguard = $('<input type="checkbox" id="OxGuardOn" name="reqpassword" value="reqpass" style="margin-top: -5px;margin-right:5px;">');
        var guard = $('<span style="padding-right:5px;padding-bottom:15px;"></span>');
        guard.append(oxguard).append(gt('Enable Guard'));
        var onoff = $(sectiondiv + '</div>').append(guard);
        // Main options DIV

        var optionsdiv = $('<div class="section-item oxguard_options" id="oxguarddiv" style="display:none; margin-top:5px;"></div>');
        // Put it together
        //#. Retract email in selected time.  Next is dropdown box with options of time
        var selector = $(sectiondiv + '<span style="padding-right:5px;">' + gt('Retract in') + ': </span><select class="oxguard_option" id="expdatepicker" style="width:100px; left:7px;"><option value="0">' + 
                //#. Never retract email (default setting)
                gt('Never') + '</option>' +
                //#. Time until email is retracted
        '<option value="24">' + gt('%s hours', '24') + '</option><option value = "48">' + gt('%s hours', '48') + '</option><option value="72">' + gt('%s hours', '72') + '</option><option value="168">' + gt('%s week', '1') + '</option><option value="336">' + gt('%s weeks', '2') + '</option>' +
        '</select></span></div>');
        var passoption = $(sectiondiv + '<span style="padding-right:5px;padding-top:15px;">' +
                '<input type="checkbox" id="reqpassword" name="reqpassword" value="reqpass" style="margin-top: -5px;margin-right:5px;">' + gt('Require Additional Password') + '</span></div>');
    //    var passwordbox = $(sectiondiv + '<input class="oxguard_option" type="password" id="passbox" placeholder="Password" style="width:100px;"/></div>');
        var passwordbox = $('<input type="hidden" id="passbox"/>');
        optionsdiv.append(onoff);
        if (window.oxguarddata !== undefined) {
            if (window.oxguarddata.settings.extrapass !== 'false') {
                optionsdiv.append(passoption).append(passwordbox);
            }
        }
        optionsdiv.append(selector);
        passwordbox.hide();

        passoption.click(function () {
            if (view.find('#reqpassword').is(':checked')) {
                core.lock(view, baton);
                core.saveToHeader(view);
                createExtraPasswordPrompt(view);
            } else {
                core.saveToHeader(view);
            }
        });

        // Put the lock up if enabled
        oxguard.click(function () {
            core.saveToHeader(view);
            if (view.find('#islocked').length === 0) {
                if (oxguard.is(':checked')) {
                    core.lock(view, baton);
                } else {
                    core.unlock(view);
                }

            }
        });
        if (view === null) createExtraPasswordPrompt(view);
        var securelink = $('<div class="section-link"></div>');
        var secureoptions = $('<a href="#" id="oxguardlink" data-section-link="security">' + gt('Security Options') + '</a>');
        securelink.append(secureoptions);
        securelink.append(optionsdiv);
        view.find('[data-section-link="options"]').parent().before(securelink);
        secureoptions.click(function (ev) {
            if (optionsdiv.is(':visible')) {
                optionsdiv.slideUp();
                ev.preventDefault();
                return;
            }
            // If already created, just slide down
            if (optionsdiv.length > 0) {
                optionsdiv.slideDown();
                ev.preventDefault();
                return;
            }
        });
        $('#expdatepicker').on('change', function () {
            if ($('#expdatepicker').val() !== '0') {
                core.lock(view, baton);
            }
        });
        // If this is a secure reply, then disable all of the options to make it plain text
        if ((window.oxguarddata.action === 'secureReply') || (window.oxguarddata.action === 'fileAttach')) {
            view.find('#statuslock')
             //   .attr("src", "apps/oxguard/images/lock32.png")
                .attr('class', lockclass)
                .click(false)
                .attr('title', gt('Reply must be encrypted'));
            view.find('.btn-primary:visible').html(gt('Send Secure'));
            view.find('#OxGuardOn').prop('checked', true).prop('enabled', false).prop('disabled', true);
            if ((window.oxguarddata.action === 'secureReply') && (window.oxguarddata.settings.oxguard === false)) {
                // If secure reply, and does not have OG, only allow reply to orig 
                $('#writer_field_to').remove();
                $('#writer_field_cc').remove();
                $('#writer_field_bcc').remove();
            }

            window.setTimeout(function () {
                core.saveToHeader(view);
                core.checkRecip(view);
            }, 5000);
        }
        
        // If default is to use guard, go ahead and lock
        if (window.oxguarddata.settings.defaultGuard) {
            core.lock(view, baton);
        }

        // Handlers for updating header for storage
        $(document).ready(function () {
            view.find('.oxguard.radio').click(function () {
                core.saveToHeader(view);
            });
            view.find('#expdatepicker').change(function () {
                core.saveToHeader(view);
            });
            view.find('#passbox').on('input', function () {
                core.saveToHeader(view);
            });
            window.setTimeout(function () {
                retrieveOxGuard(view, baton);
                core.saveToHeader(view);
            }, 500);
        });

        return;
    } 
    
    
    return {
        createOptions : createOptions,
        retrieveOxGuard : retrieveOxGuard
    };
});