/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */

define('oxguard/mail/checker', ['io.ox/core/extensions', 'gettext!oxguard/mail/checker'],
                              function (ext, gt) {
    
    // Check if OxGuard email, and if so, send to decrypt or prompt password
    function checkOG(baton) {
        if (baton.view.model === null) {
            return;
        }
        // Check if alreay done...
        if ((baton.decoded === true) || (baton.data.decoded === true)) {
            // Check to see if they are members, and if not, display upsell
            try {
                $('#loading').remove();
                baton.view.$el.show();
                baton.view.$el.find('.attachment-preview').hide();
                if (window.oxguarddata.settings.oxguard === false) {
                    var location = baton.view.$el.find('.detail-view-header');
                    upsell(location);
                }
            } catch (e) {
                
            }
            return;// if this is an already decrypted email, then return
        }
        window.oxguarddata.temp = null;
        var headers = baton.view.model.get('headers');
        if (headers === undefined) {// not yet loaded
            return;
        }
        // Init
        if (baton.data.headers === undefined) { // If email wasn't fully loaded into baton, do so now.
            baton.data = baton.view.model.toJSON();
        }
        
        if (window.oxguarddata.settings === undefined) {// If OG settings not yet loaded, store baton for finish load
            window.oxguarddata.baton = baton;
        }
        
        if (headers['X-OxGuard-Guest'] !== undefined) { // Although it's an OG email, guest from other system, so stop and show.
            if (headers['X-OxGuard-Domain'] !== undefined) {
                // If domain in email is same as in URL, probably upgraded account, should show password prompt
                if (getURL().indexOf(headers['X-OxGuard-Domain']) < 0) {
                    $('#loading').remove();
                    baton.view.$el.show();
                    return;
                }
            } else {
                $('#loading').remove();
                baton.view.$el.show();
                return;
            }
        }
        
      //If header states an oxguard email, then start
        if (headers['X-OxGuard-ID'] !== undefined) {
            require (['oxguard/mail/oxguard_mail', 'oxguard/mail/getmail'] , function (oxmail, reader) {
                baton.view.$el.find('.alert.external-images').hide();
                
                baton.model.trigger('change', baton.model, this); //trigger   redraw inbox list icon
                baton.data.og = true;
                var location = this;
                baton.view.expand();
                $('#loading').remove();
                // Check to see if we should be requesting passwords
                if ((window.oxguarddata.passcode === null) || ((headers['X-OxGuard-ExtraPass'] !== undefined) && (headers['X-OxGuard-ExtraPass'] !== ''))) {
                    baton.view.listenTo(baton.view.model, 'change:attachments', function () {
                        checkOG(baton);
                        if (baton.view.$el === null) return;
                        baton.view.$el.find('#oxgrpass').focus();
                    });
                    window.setTimeout(function () {// Diplay password prompt
                        if (baton.view.$el === null) return;
                        baton.view.$el.find('.content').replaceWith(oxmail.passwordPrompt(baton, false, location));
                        baton.view.$el.find('#oxgrpass').focus();
                        baton.view.$el.show();
                        baton.view.$el.find('.attachments').remove();
                        baton.view.$el.find('.subject').html(baton.data.subject.replace('OXGrd::', '').replace('OXGrd:', ''));
                        baton.view.expand();
                    }, 10);
                } else {
                    
                    if (window.oxguarddata.passcode.indexOf('Password Needed') > -1) {// If no password for user has been defined, open dialog
                        createOxGuardPasswordPrompt(baton, '');
                        return;
                    }
                    if (window.oxguarddata.passcode.indexOf('No Key') > -1) {// If received a first encrypted email while already logged in, will still have 'no key' in passcode
                        createOxGuardPasswordPrompt(baton, '');
                        return;
                    }
                    if ((window.oxguarddata.passcode === 'NoPrivate') || (window.oxguarddata.passcode === 'No Key')) {// No key would really only occur in a demo reset
                        window.setTimeout(function () {// Diplay password prompt
                            baton.view.$el.show();
                            baton.view.$el.find('.content').replaceWith(oxmail.passwordPrompt(baton, false, location));
                            $('#oxgrpass').focus();
                            baton.view.$el.find('.attachments').remove();
                        }, 100);
                        return;
                    }
                    $('#loading').remove();
                    reader.getMail(baton, window.oxguarddata.passcode, '', '', location)
                    .done(function () {
                        baton.view.$el.show();
                        baton.view.$el.find('section').show();
                        baton.view.$el.find('.attachment-preview').hide();
                        baton.model.on('change:attachments', function () {// Attachments occasionally reloaded after decoded
                            if (baton.decodedData !== undefined) {// If already decoded, redraw decoded data
                                if (baton.view.model !== null) {
                                    if (baton.view.model.get('attachments').length !== baton.decodedData.attachments.length) {
                                        baton.view.model = new Backbone.Model(baton.decodedData);
                                        baton.view.redraw();
                                        baton.view.expand();
                                    }
                                }
                            }
                            
                        });
                    })
                    .fail(function () {
                        console.log('fail og load');
                        baton.model.on('change:attachments', function () {
                            window.oxguarddata.passcode = null;
                            checkOG(baton);
                        });
                    });
                
                }
            });
          //  baton.view.loaded = true;
        } else {
            $('#loading').remove();
            baton.view.$el.show();  // Not OG email, show contents
        }
    }
    
    function upsell(location) {
        var params = '&cid=' + ox.context_id + '&id=' + ox.user_id + '&lang=' + ox.language;
        require(['oxguard/core/og_http'], function (og_http) {
            og_http.get(ox.apiRoot + '/oxguard/mail?action=upsell', params)
            .done(function (data) {
                location.after(data);
            });
        });
    }
    
    function getURL() {
        var matches = document.URL.match(/^https?\:\/\/([^\/?#]+)(?:[\/?#]|$)/i);
        var domain = matches && matches[1];
        if (domain === null) domain = '';
        return (domain);
    }
    
    ///////////  First time OG users
    
    // If the user has received encrypted objects, but hadn't since logged in, the need to assign a password to protect their keys
    function createOxGuardPasswordPrompt(baton, errors, oldpass)
    {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.ModalDialog({ width: 450, center: true, enter : 'okpass'});
            dialog.header($('<h4>').text(gt('First Guard Security Password Use')));
            var explain = $('<div><p>' + gt('Please change the initial temporary Guard security password that was sent to you in a seperate email.') + '</p></div>');
            
            var passdiv = $('<div>').addClass('row-fluid');
            var table = $('<table class="og_password_prompt"/>')
            .append('<tr><td class="pw"><em>' + gt('Initial Password') + ':</em></td><td><input name="oldogpassword" type="password"/></td></tr>')
            .append('<tr><td class="pw"><em>' + gt('New Password') + ':</em></td><td><input name="newogpassword" type="password"/></td></tr>')
            //#. Confirm new password
            .append('<tr><td class="pw"><em>' + gt('Confirm New') + ':</em></td><td><input name="newogpassword2" type="password"/></td></tr>');
            passdiv.append(table);
            dialog.getBody().append(explain).append(passdiv);
            var rule = $('<hr style="padding:10px;"/>');
            var recovery = $('<p>' + gt('Please enter a secondary email address in case you need to reset your password' + '</p>'));

            var table2 = $('<table class="og_password_prompt"/>');
            var row = $('<tr><td class="pw"><em>' + gt ('Email:') + '</em></td><td><input name="recoveryemail"/></td></tr>');
            table2.append(row);
            dialog.getBody().append(rule).append(recovery).append(table2);

            if (errors !== undefined) {
                dialog.getBody().append('<div><span style="color: red;">' + errors + '</span></div>');
            }
            dialog
            .addPrimaryButton('okpass', gt('OK'), 'okpass')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('okpass', function () {
                var oldpass = $('input[name="oldogpassword"]').val();
                var pass1 = $('input[name="newogpassword"]').val();
                var pass2 = $('input[name="newogpassword2"]').val();
                var emailaddr = $('input[name="recoveryemail"]').val();
                if (pass1 !== pass2) {
                    $('input[name="newogpassword2"]').css('background-color', 'salmon');
                    createOxGuardPasswordPrompt(baton, gt('Passwords not equal'), oldpass);
                    return;
                }
                var userdata = {
                        newpass : pass1,
                        oldpass : oldpass,
                        email: emailaddr,
                        user_id : ox.user_id,
                        sessionID : ox.session,
                        cid : ox.context_id
                    };
                if ((emailaddr.length > 1) && (!validateEmail(emailaddr))) {
                    createOxGuardPasswordPrompt(baton, gt('Enter new secondary Email address'), oldpass);
                    return;
                }
                if (validateEmail(emailaddr)) userdata.email = emailaddr;
                require (['io.ox/core/notifications', 'oxguard/mail/oxguard_mail', 'oxguard/mail/getmail', 'oxguard/core/og_http'], function (notifications, oxmail, reader, og_http) {
                    og_http.post(ox.apiRoot + '/oxguard/login?action=changepass', '&session=' + ox.session, userdata)
                    .done(function (data) {
                        if (typeof data === 'string') data = $.parseJSON(data);
                        if (data.auth.length > 20) {
                            $('#grdsettingerror').text(gt('Success'));
                            $('input[name="newogpassword"]').val('');
                            $('input[name="newogpassword2"]').val('');
                            window.oxguarddata.passcode = null;
                            reader.getMail(baton, data.auth, '', '');
                            notifications.yell('success', gt('Password changed successfully'));
                        } else {
                            if (data.auth === 'Bad new password') {
                                notifications.yell('error', gt('New password must be at least %s characters long', data.minlength));
                                return;
                            }
                            if (data.auth === 'Bad password') {
                                //#. Bad, incorrect password
                                notifications.yell('error', gt('Bad password'));
                                return;
                            }
                            if (data.auth === 'Key not found') {
                                notifications.yell('error', gt('Encryption key not found'));
                                return;
                            }
                            notifications.yell('error', gt('Failed to change password'));
                        }
                    
                    })
                    .fail(function () {
                        notifications.yell('error', gt('Failed to change password'));
                    });
                });
            })
            .show(function () {
                if (oldpass !== undefined) {
                    $('input[name="oldogpassword"]').val(oldpass);
                    $('input[name="newogpassword"]').focus();
                } else
                    $('input[name="oldogpassword"]').focus();
                window.setTimeout(function () {
                    var j = 0;
                    $('.pw').each(function(i,v) { 
                        var w = $(v).width();
                        if (w > j) j = w;
                        });
                    $('.pw').each(function(i,v) {
                        $(v).width(j);
                    });
                    var email = $('input[name="recoveryemail"]'); // Watch email entry for valid
                    email.on('keyup', function () {
                        if (validateEmail(email.val())) {
                            email.css('background-color', 'white');
                        } else {
                            email.css('background-color', 'rgb(253, 187, 179)');
                        }
                    });
                },0);
            });
        });
    }
    
    function validateEmail(email) {
        var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }
 
    
    
    
    return {
        checkOG : checkOG
    };
    
});