/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/file/register_file', ['io.ox/core/extensions', 'io.ox/core/capabilities', 'oxguard/oxguard_core',
                           'gettext!oxguard/file/register_file',
                           'io.ox/core/extPatterns/links',
                           'css!oxguard/style.css'],
                           function (ext, capabilities, oxguard, gt, links) {
    'use strict';

    var lockclass = 'icon-lock icon-2x fa fa-lock fa-2x og_filelock_icon';
    var unlockclass = 'icon-unlock icon-2x fa fa-unlock fa-2x og_filelock_icon';
    
    if (!(capabilities.has('guard:drive') || capabilities.has('guard-drive'))) {
        if (window.oxguarddata !== undefined) {
            window.oxguarddata.files = false;
        }
        return;
    }
    
    require(['oxguard/file/uploader'], function (uploader) {
        uploader.modifyUploadVersion();
    });
    
    ///////////////////////////////////////  Display of file icons

    ext.point('io.ox/files/icons').extend({
        id: 'ogselection',
        index: 'last',
        register: function (baton) {
            baton.app.selection.on('change', function (e, list) {
                checkSelected(list, baton);
            });
        }
        
    });
    ext.point('io.ox/files/icons/file').extend({
        index: 1000,
        id: 'oxguardfile',
        draw: function (baton) {
            var encrypted = false;
            if (isOGFile(baton.data.filename)) {
                encrypted = true;
                var extra = (baton.data.filename.indexOf('.grd2') > 0);
                $(this)[0].innerHTML = removesuffix($(this)[0].innerHTML);
                $(this).css('position', 'relative');
                var previewcover = $(this).find('.preview-cover');
                var stack = $('<span class="og_file_list fa-stack"/>');
                var lockicon = $('<i class="oxguard_lock fa fa-lock fa-stack-2x og_fa" style="font-size: 24px;"/>');
                stack.append(lockicon);
                if (extra) {
                    var plusicon = $('<i class="fa fa-plus fa-stack-1x og_fa" style="font-size: 0.5em !important; margin-top:4px; color:grey;"/>');
                    stack.append(plusicon);
                }
                previewcover.append(stack);

                var preview = $(this).find('.preview');
                stack = $('<span class="og_file fa-stack"/>');
                lockicon = $('<i class="og_file_icon oxguard_lock fa fa-lock fa-stack-2x"/>');
                stack.append(lockicon);
                if (extra) {
                    var plusicon = $('<i class="og_file_icon fa fa-plus fa-stack-1x" style="font-size: 0.5em !important; margin-top:11px; color:grey;"/>');
                    stack.append(plusicon);
                }
                preview.prepend(stack);
                baton.disable('io.ox/files/details', 'preview');
            }
     //        $(this).click(function () {
     //           console.log('enable/disable links');
    //            if (encrypted) {
    //                ogLinks();
    //            } else {
    //                regLinks();
     //           }

        //    });
        }
    });
    
    function checkSelected(list, baton) {
        var encrypted = false;
        for (var i = 0; i < list.length; i++) {
            var fileIds = baton.allIds;
            for (var j = 0; j < fileIds.length; j++) {
                if (fileIds[j].id === list[i].id) {
                    if (isOGFile(fileIds[j].filename)) {
                        encrypted = true;
                    }
                    break;
                }
            }
            if (encrypted) break;
        }
        if (encrypted) {
            ogLinks();
        } else regLinks();
    }
    
    function ogLinks() {
        if (_.device('small')) return;
        ext.point('io.ox/files/versions/links/inline').disable('open');
        ext.point('io.ox/files/details').disable('upload');
        ext.point('io.ox/files/details').enable('uploadOGVersion');
        ext.point('io.ox/files/details').disable('preview');
        ext.point('io.ox/files/icons/inline').disable('download');
        ext.point('io.ox/files/classic-toolbar/links').disable('sendlink');

    }
    
    function regLinks() {
        if (_.device('small')) return;
        ext.point('io.ox/files/versions/links/inline').enable('open');
        ext.point('io.ox/files/details').enable('upload');
        ext.point('io.ox/files/details').disable('uploadOGVersion');
        ext.point('io.ox/files/details').enable('preview');
        ext.point('io.ox/files/icons/inline').enable('download');
        ext.point('io.ox/files/classic-toolbar/links').enable('sendlink');

    }

    
    // For mobile, add a decrypt button
    ext.point('io.ox/files/details').extend({
        index: 500,
        id: 'downloadOGsmall',
        draw: function (baton) {
            if (_.device('small')) {
                if (_.device('ios')) return;   // ios doesn't allow downloading.
                if (baton.data.ogfile === true) {
                    var download = $('<a href="#" class="btn btn-default">' + gt('Download Decrypted') + '</a>');
                    download.click(function (ev) {
                        ev.preventDefault();
                        var list = [baton.data];
                        if (extrapasslist(list)) {
                            oxPasswordPrompt('download', list, true);
                            return;
                        }
                        if (window.oxguarddata === undefined) {
                            oxPasswordPrompt('download', list, false);
                            return;
                        }
                        if ((window.oxguarddata.passcode === null) || (window.oxguarddata.passcode.length < 20)) {
                            oxPasswordPrompt('download', list, false);
                            return;
                        }
                        require (['oxguard/file/downloader'], function (downloader) {
                            downloader.getFile(list, 'download', window.oxguarddata.passcode);
                        });
                        
                    });
                    $(this).append(download);
                }
            }
        }
    });
    
    
    /////// Files Details
    
    // Action points
    
    ext.point('io.ox/files/actions/open').replace({
        id: 'default',
        requires: function (e) {
            if (e.collection.has('multiple')) return false;
            if (e.baton.data) {
                if (e.baton.data.meta) {
                    if (e.baton.data.meta.Encrypted === true || (isOGFile(e.baton.data.filename))) {
                        return(false);
                    }
                }
            }
            // 'description only' items
            return !_.isEmpty(e.baton.data.filename) || e.baton.data.file_size > 0;
        }
    });

    
    ext.point('io.ox/files/links/inline').extend(new links.Link({
        id: 'encrypt',
        index: 550,
        label: gt('Encrypt'),
        ref: 'oxguard/encrypt',
        mobile: 'lo',
        section: 'guard'
    }));
    
    ext.point('io.ox/files/classic-toolbar/links').extend(new links.Link({
        id: 'encrypt',
        index: 150,
        label: gt('Encrypt'),
        ref: 'oxguard/encrypt'
    }));
    
    ext.point('io.ox/files/links/inline').extend(new links.Link({
        id: 'decodeOpen',
        index: 1,
        label: gt('Decrypt and Open'),
        ref: 'oxguard/open',
        prio: 'hi',
        mobile: 'hi',
        section: 'guard'
    }));
    
    ext.point('io.ox/files/links/inline').extend(new links.Link({
        id: 'remencrypt',
        index: 151,
        label: gt('Remove Encryption'),
        ref: 'oxguard/remencrypt',
        mobile: 'lo',
        section: 'guard'
    }));
    
    ext.point('io.ox/files/classic-toolbar/links').extend(new links.Link({
        id: 'remencrypt',
        index: 151,
        label: gt('Remove Encryption'),
        ref: 'oxguard/remencrypt',
        section: 'guard'
    }));
    
    ext.point('io.ox/files/links/inline').extend(new links.Link({
        id: 'downencrypt',
        index: 151,
        label: gt('Download Decrypted'),
        ref: 'oxguard/download',
        mobile: 'lo',
        section: 'guard'
    }));
    
    ext.point('io.ox/files/icons/inline').extend(new links.Link({
        id: 'OGdownload',
        index: 600,
        prio: 'lo',
        mobile: 'lo',
        label: gt('Download'),
        ref: 'oxguard/open'
    }));
    
    
    ext.point('io.ox/files/links/inline').disable('send'); // Rename send to send copy
    
    ext.point('io.ox/files/links/inline').extend(new links.Link({
        id: 'sendcopy',
        index: 500,
        prio: 'lo',
        label: gt('Send copy by mail'),
        ref: 'oxguard/sendcopy',
        section: 'share'
    }));
    

    ext.point('io.ox/files/classic-toolbar/links').disable('send');
    ext.point('io.ox/files/classic-toolbar/links').extend(new links.Link({
        id: 'sendcopy',
        index: 800,
        prio: 'lo',
        mobile: 'lo',
        label: gt('Send copy by mail'),
        ref: 'oxguard/sendcopy',
        section: 'share'
    }));
    
    
    
    new links.Action('oxguard/editor', {
        requires: false,
        action: function () {
        }
    });
    
    
    new links.Action('oxguard/sendcopy', {
        requires: false,
        multiple: function (list) {
            list.map(function (file) {
                if (file.filename.indexOf('.grd') > 0) {
                    window.oxguarddata.action = 'fileAttach';
                }
            });
            ext.point('io.ox/files/actions/send').invoke('multiple', this, list);
            
        }
    });
    
    new links.Action('oxguard/remencrypt', {
        requires: function (e) {
            if (e.baton.data instanceof Array) {
                var files = e.baton.data;
                for (var i = 0; i < files.length; i++) {
                    if (files[i].meta) {  // If file is not encrypted, then remove menu item
                        if (files[i].meta.Encrypted !== true) return (false);
                    }
                }
                return(true);
            } else {
                if (e.baton.data) {
                    if (e.baton.data.meta) {
                        if (e.baton.data.meta.Encrypted === true || (isOGFile(e.baton.data.filename))) {
                            return(true);
                        }
                    }
                }
            }
            return (false);
        },
        multiple: function (list, baton) {
            if (list.length === 0) {
                return;
            }
            $('.btn-sidepopup').click();
            if (extrapasslist(list)) {
                oxPasswordPrompt('remove', list, true);
                return;
            }
            if (window.oxguarddata === undefined) {
                oxPasswordPrompt('remove', list, false);
                return;
            }
            if ((window.oxguarddata.passcode === null) || (window.oxguarddata.passcode.length < 20)) {
                oxPasswordPrompt('remove', list, false);
                return;
            }
            require (['oxguard/file/downloader'], function (downloader) {
                downloader.getFile(list, 'remove', window.oxguarddata.passcode);
            });
            
            baton.openedBy = 'io.ox/files';
        }
    });
    
    new links.Action('oxguard/open', {
        requires: function (e) {
            if (e.baton.data) {
                if (e.baton.data.meta) {
                    if (e.baton.data.meta.Encrypted === true || (isOGFile(e.baton.data.filename))) {
                        return(true);
                    }
                }
            }
            return (false);
        },
        multiple: function (list) {
            if (extrapasslist(list)) {
                oxPasswordPrompt('open', list, true);
                return;
            }
            if (window.oxguarddata === undefined) {
                oxPasswordPrompt('open', list, false);
                return;
            }
            if ((window.oxguarddata.passcode === null) || (window.oxguarddata.passcode.length < 20)) {
                oxPasswordPrompt('open', list, false);
                return;
            }
            var popup = window.open('', '_blank');
            require (['oxguard/file/downloader'], function (downloader) {
                downloader.getFile(list, 'open', window.oxguarddata.passcode, null, popup);
            });
            
        }
    });
    
    new links.Action('oxguard/download', {
        requires: function (e) {
            if (_.device('ios')) return false;
            if (e.baton.data) {
                if (e.baton.data.meta) {
                    if (e.baton.data.meta.Encrypted === true || (isOGFile(e.baton.data.filename))) {
                        return(true);
                    }
                }
            }
            return (false);
        },
        multiple: function (list) {
            if (extrapasslist(list)) {
                oxPasswordPrompt('download', list, true);
                return;
            }
            if (window.oxguarddata === undefined) {
                oxPasswordPrompt('download', list, false);
                return;
            }
            if ((window.oxguarddata.passcode === null) || (window.oxguarddata.passcode.length < 20)) {
                oxPasswordPrompt('download', list, false);
                return;
            }
            require (['oxguard/file/downloader'], function (downloader) {
                downloader.getFile(list, 'download', window.oxguarddata.passcode);
            });
            
        }
    });
    
    
    var saveaction = ext.point('io.ox/files/actions/send');
    saveaction.extend({
        id: 'oxguardupload',
        index: 1,
        action: function () {
        }
    });
    
    
    
    var createaction = ext.point('io.ox/files/actions/upload');
    createaction.extend({
        id: 'oxcreate',
        index: 1,
        action: function () {
        }
    });
    
    
    ext.point('io.ox/files/versions/links/inline').extend(new links.Link({
        id: 'OGopen',
        index: 100,
        label: gt('Decrypt and Open'),
        ref: 'oxguard/open'
    }));

    ext.point('io.ox/files/versions/links/inline').extend(new links.Link({
        id: 'OGdownload',
        index: 200,
        label: gt('Download Decrypted'),
        ref: 'oxguard/download'
    }));

    // Remove the loc portion of the name in version list
    ext.point('io.ox/files/details/version').extend({
        index: 1,
        id: 'ogversion',
        draw: function () {
        //    baton.data.filename = baton.data.filename.replace('.grd2', '').replace('.grd', '');
        }
    });
    
    
    //  Detail views
    
    ext.point('io.ox/files/details').extend({
        index: 1,
        id: 'oxguardfiledetail',
        draw: function (baton) {
            if (isOGFile(baton.data.filename)) {// Action for encrypted files
                baton.data.ogfile = true;
                $(this).append('<div class="oxguard_file_detail_fa"><i class="icon-lock fa fa-lock oxguard_lock oxguard_lock_large"/></div>');
                baton.data.encrypted = true;

                if (_.device('small')) {
                    ext.point('io.ox/files/links/inline').disable('download');
                } else {
                    ext.point('io.ox/files/links/inline').disable('open');
                    ext.point('io.ox/files/links/inline').disable('editor');
                    ext.point('io.ox/files/links/inline').disable('sendlink');
                    ext.point('io.ox/files/links/inline').disable('showlink');
                    ext.point('io.ox/files/links/inline').disable('add-to-portal');
                    ext.point('io.ox/files/links/inline').disable('lock');
                    ext.point('io.ox/files/links/inline').disable('publish');
                }

                window.setTimeout(function() {
                    $('.btn-file').hide();
                }, 0);
            } else {//Resotre actions for non-encrypted file
                if (_.device('small')) {
                    ext.point('io.ox/files/links/inline').enable('download');
                } else {
                    ext.point('io.ox/files/links/inline').enable('open');
                    ext.point('io.ox/files/links/inline').enable('editor');
                    ext.point('io.ox/files/links/inline').enable('sendlink');
                    ext.point('io.ox/files/links/inline').enable('showlink');
                    ext.point('io.ox/files/links/inline').enable('add-to-portal');
                    ext.point('io.ox/files/links/inline').enable('lock');
                    ext.point('io.ox/files/links/inline').enable('publish');
                }
            }
        }
    });
    
    // Add security options and file share options to detail view
    ext.point('io.ox/files/details').extend({
        id: 'fileoptions',
        index: 1000,
        draw: function (baton) {
            if (baton.data.ogfile === true) {
                var loc = this;
                var securitylink = $('<div class="og_share_link"><a href="#">' + gt('Security Options') + '</div>');
                var sharelink = $('<p class="og_share_link"><a href="#" >' + gt('Sharing') + '</p>');
                var options = $('<div class="og_file_options"/>');
            //    var extrapasslink = $('<p><a href="#" class="og_share_link">' + gt('Extra Password') + '</p>');
                var extrapassdiv = $('<div class="og_file_extra"/>');
                var passoption = $('<input type="checkbox" id="reqpassword" name="reqpassword" value="reqpass" style="margin-top: -5px;"><span style="padding-left:7px;">' + gt('Require Additional Password') + '</span></div>')
                .click(function () {
                    require(['oxguard/file/extrapass'], function (extra) {
                        extra.createExtraPasswordPrompt(baton);
                    }); 
                });
                if (baton.data.filename.indexOf('.grd2') > 0) {
                    passoption = $('<span style="padding-right:5px;padding-top:15px;">' + gt('Already Protected With Additional Password') + '</span>');
                }
                extrapassdiv.append(passoption);
                options.append(extrapassdiv);
                
                if (baton.data.meta.OGID !== undefined) {  // Add share link if encrypted and if owner
                    if ((baton.data.meta.OwnerCid !== undefined) && (baton.data.meta.OwnerId !== undefined))  {
                        if ((baton.data.meta.OwnerCid === parseInt(ox.context_id)) && (baton.data.meta.OwnerId === parseInt(ox.user_id))) {
                            if (window.oxguarddata !== undefined) {
                                if (window.oxguarddata.settings.extrapass !== 'false') {
                                    $(this).append(securitylink.append(options));
                                }
                            }
                            $(this).append(sharelink);
                        }
                    } else { ///  Prob remove in near future.  If meta data not present
                        $(this).append(securitylink.append(options));
                        $(this).append(sharelink);
                    }
                }
            //    extrapasslink.click(function (e) {
           //        extrapassdiv.toggle(300);
           //         e.preventDefault();
            //    });
                sharelink.click(function (e) {
                    sharing(loc, baton);
                    
                    e.preventDefault();
                });

                securitylink.click(function (e) {
                    options.toggle(300);
                    e.preventDefault();
                });
                
            }
            
        }
    });
    
   

 

    
    ////////  Encrypting files
    
    new links.Action('oxguard/encrypt', {
        requires: function (e) {
            if (e.baton.data instanceof Array) {
                var files = e.baton.data;
                for (var i = 0; i < files.length; i++) {
                    if (files[i].meta) {
                        if (files[i].meta.Encrypted === true || (isOGFile(files[i].filename))) return (false);
                    }
                }
            } else {
                if (e.baton.data) {
                    if (e.baton.data.meta) {
                        if (e.baton.data.meta.Encrypted === true || (isOGFile(e.baton.data.filename))) {
                            return(false);
                        }
                    }
                }
            }
            return (true);
        },
        multiple: function (list, baton) {
            if (list.length === 0) {
                return;
            }
            if (window.oxguarddata.passcode === 'No Key') {
                oxguard.createKeys()
                .done(function () {
                    doEncrypt(list, baton);
                });
                return;
            }
            doEncrypt(list, baton);
        }
    });
    
    function doEncrypt(list) {
        $('.btn-sidepopup').click();
        require (['oxguard/file/encryptor'], function (encryptor) {
            encryptor.encrFiles(list);    
        });
    }
    
    // Drag file extension
    
    ext.point('io.ox/files/dnd/actions').extend({
        id: 'createOG',
        index: 15,
        label: gt('Drop here to upload a <b class="dndignore">new encrypted file</b>'),
        multiple: function (files, app) {
            if (window.oxguarddata.passcode === 'No Key') {
                oxguard.createKeys()
                .done (function () {
                    dragUpload(files, app);
                });
                return;
            } else dragUpload (files, app);

        }
    });
    
    function dragUpload (files, app) {
        require(['oxguard/file/uploader'], function (uploader) {
            uploader.setEncrypted();
            uploader.multipleEncrypted();
            app.queues.create.offer(files, { folder: app.folder.get() });

        });
        require (['io.ox/files/api'], function (api) {
            api.on('refresh.all', function () {// Refresh called after upload, default back to regular uploading
                require(['oxguard/file/uploader'], function (uploader) {
                    uploader.endMulti();
                });
            });
        });
    }
    
    
    new links.Action('oxguard/upload', {
        requires: true,
        action: function (baton) {
            if (window.oxguarddata.passcode === 'No Key') {
                oxguard.createKeys();
                return;
            }
            require(['io.ox/files/views/create'], function (create) {
                create.show(baton.app, {
                    uploadedFile: function (data) {
                        if ('invalidateFolder' in baton.app) {
                            baton.app.invalidateFolder(data);
                        }
                    }
                });
                var sendbutton = $('.btn-primary[data-action="save"]');
                sendbutton.text('Encrypt').attr('encryption', 'true');
                $('h4').text(gt('Upload new files to encrypt'));
                require(['oxguard/file/uploader'], function (uploader) {
                    uploader.setEncrypted();
                });
            });
    
        }
    });
    

    
    ext.point('io.ox/files/create/form').extend({
        id: 'ogform',
        index: 1000,
        draw: function () {
            window.setTimeout(function () {
                var lockdiv = $('<div class="og_filelock"></div><input type="hidden" value="false" id="encr"/>');
                var lockbutton = $('<i id="file_lock" class="' + unlockclass + '"  title="' + gt('Click to enable encryption') + '"/>')
                .click(function () {
                    if ($('#encr').val() === 'false') {
                        if (window.oxguarddata.passcode === 'No Key') {
                            oxguard.createKeys()
                            .done(function () {
                                $('#encr').val('true');
                                $('.btn-primary[data-action="save"]').text(gt('Encrypt'));
                                $('#file_lock').removeClass().addClass(lockclass);
                                require(['oxguard/file/uploader', 'io.ox/files/api'], function (uploader, api) {
                                    uploader.setEncrypted();
                                    uploader.multipleEncrypted();
                                    api.on('refresh.all', function () {// Refresh called after upload, default back to regular uploading
                                        uploader.endMulti();
                                    });
                                });
                            });
                            return;
                        }
                        $('#encr').val('true');
                        $('.btn-primary[data-action="save"]').text(gt('Encrypt'));
                        $('#file_lock').removeClass().addClass(lockclass);
                        require(['oxguard/file/uploader', 'io.ox/files/api'], function (uploader, api) {
                            uploader.setEncrypted();
                            uploader.multipleEncrypted();
                            api.on('refresh.all', function () {// Refresh called after upload, default back to regular uploading
                                uploader.endMulti();
                            });
                        });
                    } else {
                        $('#encr').val('false');
                        $('.btn-primary[data-action="save"]').text(gt('Save'));
                        $('#file_lock').removeClass().addClass(unlockclass);
                        require(['oxguard/file/uploader'], function (uploader) {
                            uploader.setNotEncrypted();
                        });
                    }
                    
                });
                $('form.files-create').prepend(lockdiv.append(lockbutton));
            }, 100);
            
        }
    });
    

    
    
    
    /////////////////  Util, prompts, etc
    
    // Create a password prompt for the oxguard password
    function oxPasswordPrompt(action, list, extra)
    {
        require (['io.ox/core/tk/dialogs', 'io.ox/core/notifications', 'oxguard/file/downloader'], function (dialogs, notifications, downloader) {
            var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter : 'ok'});
            dialog.header($('<h4>').text(gt('Enter Guard Security Password')));
            var passdiv = $('<div>').addClass('row-fluid');
            passdiv.append('<input name="ogpassword" type="password"/>');
            var rem = false;
            var rememberdiv = $('<div><span style="padding:5px;">' + gt('Remember Password') + '</span></div>');
            var reminput = $('<input type="checkbox" name="rememberpass" style="margin:0 0 0;">')
                .click(function () {
                    rem = $('input[name="rememberpass"]').is(':checked');
                });
            var duration = $('<select id="fduration" class="og_duration"><option value="10">' + gt('10 minutes') + '</option>' +
                    '<option value="20">' + gt('20 minutes') + '</option>' +
                    '<option value="30">' + gt('30 minutes') + '</option>' +
                    '<option value="60">' + gt('1 hour') + '</option>' +
                    '<option value="120">' + gt('2 hours') + '</option>' +
                    '<option value="99999">' + gt('Session') + '</option' +
                    '</select>')
                    .on('change', function () {
                        $('input[name="rememberpass"]').prop('checked', true);
                        rem=true;
                    });
            var extraprompt = $('<div style="padding-top:10px;"><span>' + gt('Extra Password') + ': </span><input type="password" id="extra"/></div>');
            if (!extra) {
                rememberdiv.prepend(reminput);
                rememberdiv.append(duration);
                passdiv.append(rememberdiv);
            }
            dialog.getBody().append(passdiv);
            if (extra) dialog.getBody().append(extraprompt);
            dialog
            .addPrimaryButton('ok', gt('OK'), 'ok')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('ok', function () {
                var extrapass = $('#extra').val();
                var time = $('#fduration').val() * 1000 * 60;
                var popup = null;
                if (action === 'open') {
                    popup = window.open('', '_blank');
                }
                oxguard.auth(ox.user_id, $('input[name="ogpassword"]').val(), extrapass)
                .done(function (data) {
                    if (data.auth === 'Bad Password') {
                        if (popup) popup.close();
                        //#. Bad, incorrect password
                        notifications.yell('error', gt('Bad password'));
                        return;
                    }
                    if (data.auth === 'Lockout') {
                        if (popup) popup.close();
                        notifications.yell('error', gt('Temporary Lockout'));
                        return;
                    }
                    if (rem) {
                        window.oxguarddata.passcode = data.auth;
                        $('.og_signout').show();
                        window.setTimeout(function () {
                            window.oxguarddata.passcode = null;
                            $('.og_signout').hide();
                        }, time);
                    }
                    downloader.getFile(list, action, data.auth, data.encrExtra, popup);
    
                })
                .fail(function () {
                    
                });
                
            })
            .show(function () { $('input[name="ogpassword"]').focus(); 
                window.setTimeout(function () {
                    $('input[name="ogpassword"]').focus();
                }, 100);
            });
        });
    }

   
    
    function sharing(loc, baton) {
        require(['oxguard/file/share',
                 'io.ox/core/tk/dialogs'], function (share, dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 450, center: true});
            dialog.header($('<h4>').text(gt('Sharing')));
            var instr = $('<p>' + gt('Share keys with other users to decrypt this file') + '</p>');

            var sharediv = $('<div class="og_sharelist"><table class="og_sharetable"/></div>');
            var sendlink = $('<button type="submit" class="btn og_action_button" style="display:none;" id="linkbutton">' + gt('Share link') + '</button>')
            .click(function () {
                share.sharelink(baton);
                dialog.close();
            });
            var shareactions = $('<div class="og_share_actions"></div>').append(sendlink);
            // .append(sendmail);
            sharediv.append(shareactions);
            dialog
            .addPrimaryButton('ok', gt('OK'), 'ok')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('ok', function () {
            });
            var input = share.createShareInput.call(loc, baton.data.meta.OGID);
            var sharetable = $('<div id="og_file_share' + baton.data.meta.OGID + '" class="og_file_share_table"/>').append('<div class="io-ox-busy"/>');
            dialog.getBody().append(instr).append(input).append(sharetable).append(shareactions);
            share.buildshare(baton.data.meta.OGID);
            dialog.show(function () {
                window.setTimeout(function () {
                   input.focus(); 
                }, 200);
            });
        });

        
    }
    
    function isOGFile(filename) {
        try {
            if (filename === null) return(false);
            if ((filename.indexOf('.grd') > 0) || (filename.indexOf('.grd2') > 0)) return (true);
        } catch (e) {
            return(false);
        }
        return (false);
    }
    
    function removesuffix(filename) {
        return (filename);
    //    return (filename.replace('.grd2', '').replace('.grd', ''));
    }
    
    function extrapass(filename) {
        if ((filename.indexOf('.grd2') > 0)) return (true);
        return (false);
    }
    
    function extrapasslist(list) {
        for (var i = 0; i < list.length; i++) {
            if (extrapass(list[i].filename)) return (true);
        }
        return (false);
    }


    
    ////////////////////////////////////////////////////////////// Folders
    
/* jshint ignore:start */

    function addFolder(e) {
        e.preventDefault();
        ox.load(['io.ox/core/folder/add']).done(function (add) {
            add(e.data.folder, { module: e.data.module });
        });
    }
   
    var POINT = 'io.ox/files/folderview';
    // toolbar actions

    function add(folder, title, opt) {

        require (['io.ox/files/api', 'io.ox/core/api/folder', 'io.ox/core/notifications'], function (api, folderapi, notifications) {
            var opt = opt || {}, invalid = false;
    
            // check for valid filename
            ext.point('io.ox/core/filename')
                .invoke('validate', null, title, 'folder')
                .find(function (result) {
                    if (result !== true) {
                        notifications.yell('warning', result);
                        return (invalid = true);
                    }
                });
    
            if (invalid) return $.Deferred().reject();
    
            // call API
            return folderapi.create({
                folder: folder,
                data: {
                    title: $.trim(title),
                    module: opt.module,
                    meta : {
                        encrypted: true
                    }
                }
            });
        });

    }
    
    ext.point('io.ox/foldertree/folder').extend({
        index: 200,
        id: 'encrypted',
        customize: function (baton, dat1, dat2) {
            if (baton.meta !== null && baton.meta !== undefined) {
                if (baton.meta.encrypted === true) {
                    $(this).find('.folder-label').prepend('<i class="icon-lock icon-large fa fa-lock -fa-large oxguard_lock oxguard_file_lock"></i>');
                }
            }

        }
    });
    

    //////////////
    //DISABLED FOR NOW.  CHANGE draw_disabled to draw to activate
    ext.point(POINT + '/sidepanel/context-menu').extend({
        id: 'add-folder2',
        index: 91,
        draw_disabled: function (baton) {
            if (baton.data.meta !== null && baton.data.meta !== undefined) {
                if (baton.data.meta.encrypted === true) {
                    ext.point('io.ox/files/icons/inline').disable('upload');
                    ext.point('io.ox/files/icons/inline').enable('uploadencr');
                } else {
                    ext.point('io.ox/files/icons/inline').disable('uploadencr');
                    ext.point('io.ox/files/icons/inline').enable('upload');
                }
            } else {
                ext.point('io.ox/files/icons/inline').disable('uploadencr');
                ext.point('io.ox/files/icons/inline').enable('upload');
            }

            // only mail and infostore show hierarchies
            this.append(
                $('<li>').append(
                    $('<a href="#" tabindex="1" data-action="add-subfolder" role="menuitem">')
                    .text(gt('New encrypted subfolder'))
                    .on('click', function () {
                        require (['io.ox/core/tk/dialogs'], function (dialogs) {
                            new dialogs.ModalDialog({
                                async: true,
                                width: 400,
                                enter: 'add'
                            })
                            .header(
                                $('<h4>').text(
                                        baton.data.id === '2' ? gt('New public folder') :
                                        baton.data.id === '1' ? gt('New Encrypted folder') : gt('New Encrypted subfolder')
                                )
                            )
                            .build(function () {
    
                                this.getContentNode().append(
                                    $('<div class="row-fluid">').append(
                                        $('<input type="text" class="span12">').attr('placeholder', gt('Folder name'))
                                    )
                                );
                            })
                            .addPrimaryButton('add', gt('Add folder'))
                            .addButton('cancel', gt('Cancel'))
                            .on('add', function () {
                                add(baton.data.id, this.getContentNode().find('input').val(), {})
                                .then(this.close, this.idle);
                                
                            })
                            .show(function () {
                                this.find('input').val(gt('New folder')).focus().select();
                            });
                        });
                    })
                ),
                $('<li class="divider">')
            );
        }
    });
/* jshint ignore:end */
    
});
