/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */

define('oxguard/file/downloader', ['gettext!oxguard/file/downloader', 'oxguard/core/og_http'],
                              function (gt, og_http) {
    // Download a file to browser or as download
    
    function getFile(list, action, auth, extrapass, popup)
    {
        list.map(function (file) {
            if (file.filename.indexOf('.grd') > 0) {// Make sure OxGuard file
                var params = '&id=' + file.id +
                '&folder=' + file.folder_id +
                '&session=' + ox.session +
                '&auth=' + encodeURIComponent(auth) +
                '&userid=' + ox.user_id +
                '&cid=' + ox.context_id +
                '&version=' + (file.version ? file.version : '-1') +
                '&download=' + (action === 'download') +
                '&language=' + ox.language +
                '&encrextra=' + (extrapass === undefined ? '' : encodeURIComponent(extrapass)) +
                '&filename=' + encodeURIComponent(file.filename);
                
                if (action === 'remove') {
                    og_http.get(ox.apiRoot + '/oxguard/file?action=remove', params)
                    .done(function () {//Get the key
                        require (['io.ox/files/api'], function (api) {
                            api.trigger('refresh.all');
                        });
                        
                    })
                    .fail(function (data) {
                        require (['io.ox/core/notifications'], function (notifications) {
                            if (data.responseText.indexOf('Bad Password') > -1) {
                                //#. Bad, incorrect password
                                notifications.yell('error', gt('Bad Password'));
                                return;
                            }
                            if (data.responseText.indexOf('Unable to save') > -1) {
                                notifications.yell('error', gt('Unable to save decrypted file'));
                                return;
                            }
                            notifications.yell('error', gt('Unable to decrypt') + '\r\n' + data.responseText);
                        });
 
                    });
                } else {
                    var link = ox.apiRoot + '/oxguard/file/' + encodeURIComponent(file.filename.replace('.grd2', '').replace('.grd', '')) + '?action=get' + params;

                    if (action === 'download') {
                        iframe(link, file.id);
                    } else {
                        //Try opening in popup.  
                        if (popup === null || popup === undefined) {
                            require (['io.ox/core/notifications'], function (notifications) {
                            //#. Error message when trying to open a file with popup blocker on browser blocking
                                notifications.yell('error', gt('Your pop-up blocker may have prevented a Guard window that provides application functionality.'));
                              //  window.location.href = link;
                            });
                        } else {
                            popup.location.href = link;
                        }
                    }
                }
                
            }

        });
    }
    
    
    function iframe(url, fileid) {
        $('#tmp').append(
            $('<iframe>', { src: url, 'class': 'hidden download-frame', id: 'download' + fileid })
        );
    }
    
    return {
        getFile : getFile
    };
});