﻿/// <reference path="jquery-1.7.1.js" />

var userid;
var cid;
var sessionID;
var auth;

try {// Load root from config file.  Error if missing or unable to determine api address
    var root = getRoot();
} catch (e) {
    var i = window.location.pathname.indexOf('appsuite/api');
    if ( i > 0) {
        var path = window.location.pathname.substring(0, i) + 'appsuite/api/';
        root = window.location.protocol + "//" + window.location.host + path;
    } else alert('missing or corrupt config.js file');
}

var language = getURLParameter('lang');

$().ready(function () {// Once ready, load templates.  
    var cid = getURLParameter("cid");
    // Add addditional templates here.  Specify contextID, the template file, and the location
    getTemplate(cid, "header.html", "top-bar-placeholder");
    
    // Template for css.  Format cid-style.css
    if (cid !== null) {
        $('head').append('<link rel="stylesheet" type="text/css" href="./templates/' + cid + '-style.css">');
    }
    $.get('./l10n/languages', function (languages) {
        $.each(languages, function (c, n) {
            $('#languageSelect').append('<li><a href="#" language="' + c + '">' + n + '</a></li>');
        });
        var user = getURLParameter('user');
        if (user !== null) {
            $('#Username').val(user);
            $('#Password').focus();
        }
    }, 'json');

    // Language selection listener
    $("#languageSelect").click(loadLanguage);
});

function loadLanguage (ev) {
    var url = document.URL;
    if (url.indexOf("&lang") > 0) {
        url = url.substring (0, url.indexOf("&lang"));
    }
    url = url + "&lang=" + $(ev.target).attr("language");
    window.location.replace(url);
}

// Load the template.  Format should be cid-template .  Location in template subdirectory
function getTemplate (cid, template, locationID) {
    $.get('./templates/' + (cid === null ? "" : (cid + "-")) + template, function (data) {
        $('#' + locationID).replaceWith(data);
    })
    .fail(function () {// If not found with cid, try loading default
        $.get('./templates/' + template, function (data) {
            $('#' + locationID).replaceWith(data);
        });
    });
}


// Provides login to oxguard backend.  Authentication key is returned and stored
function login() {
    var username = $('#Username').val();
    var password = $('#Password').val();
    if(typeof String.prototype.trim === 'function') {// Trim not supported in IE
        password = $('#Password').val().trim();
    }
    $('#authorizing').show();
    var logindata = {
            username : username,
            password : password
    }
    $.post(root + "oxguard/login?action=guest", JSON.stringify(logindata), function (data) {
        log("loging data: ", data);
        if (data === null) {
            alert('error');
            return;
        }
        if (data.auth === "Password Needed") {
            $('#login').hide();
            $('#NewPassword').show();
            userid = data.userid;
            cid = data.cid;
            sessionID = data.sessionID;
            auth = data.auth;
            return;
        }
        if (data.auth === "Bad Password" || data.auth === "No Key") {
            $('#ErrorBox').html(i18n.t("Bad username / Password"));
	    $('#ErrorBox').show();
            $('#Username').focus();
            $('#Username').val('');
            $('#Password').val('');
            $('#authorizing').hide();
        }
        if (data.auth === "lockout") {
            $('#ErrorBox').html(i18n.t("Account locked out try later"));
            $('#ErrorBox').show();
	    $('#Username').hide();
            $('#Password').hide();
            $('#LoginButton').hide();
            $('#authorizing').hide();
        }
        if (data.auth.length > 20) {
            userid = data.userid;
            cid = data.cid;
            sessionID = data.sessionID;
            auth = data.auth;
            var extrapass = getURLParameter("extrapass");
            if (extrapass !== null) extrapass = extrapass.trim();
            if (extrapass === 'true') {
            	getExtraPass(data);
            } else {
            	openreader(data, "");
            }
        }

    })
    .fail(function (data) {
        $('#authorizing').hide();
        alert('fail');
    });
}

function showChangepass() {
	view('NewPassword');
}

// Change the oxguard password
function changePass() {
    var pass1 = $('#new1').val();
    if (pass1 !== $('#new2').val()) {
        $('#new1').focus();
        $('#ChangeError').html(i18n.t("Passwords do not match"));
	$('#ChangeError').show();
        return;
    }
    var userdata = {
        newpass: pass1,
        oldpass: $('#old').val(),
        user_id: userid,
        sessionID: sessionID,
        cid: cid
    };
    $.post(root + 'oxguard/guest?action=changepass&session=' + sessionID, JSON.stringify(userdata), function (data) {
        if (typeof data === 'string') data = $.parseJSON(data);
        log('success ', data);
        if (data.auth.length > 20) {
            auth = data.auth;
            $('#new1').val('');
            $('#new2').val('');
            $('#old').val('');
            $('#ChangeError').html(i18n.t("Password Changed"));
	    $('#ChangeError').show();
            window.setTimeout (function() {
		$('#ChangeError').html();
                $('#ChangeError').hide();
		view("Reader");
            }, 2000);

        }

    })
    .fail(function () {
        $('#ChangeError').html(i18n.t("Failed to change password"));
        $('#ChangeError').show();
    });
}

//Change the oxguard password
function firstChangePass() {
    var pass1 = $('#change1').val();
    if (pass1.length < 8) {
        $('#change1').focus();
        $('#firstChangeError').html(i18n.t("Password must be at least 8 characters long"));
        $('#firstChangeError').show();
        return;
    }
    if (pass1 !== $('#change2').val()) {
        $('#change1').focus();
        $('#firstChangeError').html(i18n.t("Passwords do not match"));
        $('#firstChangeError').show();
        return;
    }
    var answer = $('#answer').val();
    if (answer.length < 3) {
        $('#answer').focus();
        $('#firstChangeError').html(i18n.t("Please provide an answer for the security question"));
        $('#firstChangeError').show();
        return;
    }
    var password = $('#Password').val();
    if(typeof String.prototype.trim === 'function') { // Trim not supported in IE
        password = password.trim();
    }
    var userdata = {
        newpass: pass1,
        oldpass: password,
        question: $('#question').val(),
        answer: $('#answer').val(),
        user_id: userid,
        sessionID: sessionID,
        cid: cid
    };
    log("changepass data: ", userdata);
    $.post(root + 'oxguard/guest?action=changepass&session=' + sessionID, JSON.stringify(userdata), function (data) {
        if (typeof data === 'string') data = $.parseJSON(data);
        log('success ', data);
        if (data.auth.length > 20) {
            auth = data.auth;
            sessionID = data.sessionID;
            $('#new1').val('');
            $('#new2').val('');
            $('#firstChangeError').html(i18n.t("Password Changed"));
            $('#firstChangeError').show();
            window.setTimeout(function () {
                $('#firstChangeError').html();
                $('#firstChangeError').hide;
                $('#firstChangePassDiv').hide();
            },1000);
        }

    })
    .fail(function () {
        $('#firstChangeError').html(i18n.t("Failed to change password"));
        $('#firstChangeError').show();
    });
}


// Extra password is required
function getExtraPass (data) {
	view("ExtraPassDiv");
	$('#ExtraPassButton').click(function () {
		var extra = $('#extrapass').val();
		openreader(data, extra);
	});
	$('#extrapass').focus()
	.keypress(function (e) {
	    if (e.which == 13) {
	        $('#ExtraPassButton').click();
	    }
	});
}

// Open the email for reading.  Populate with decoded data
function openreader(data, extra) {
    var lastMod = data.lastMod;
    view();
    $('#decoding').show();
    var itemid = getURLParameter("email");
    var json = {
            cid : cid,
            item : itemid,
            extrapass : (extra === undefined) ? '' : extra
    }
    var url = root + 'oxguard/guest?action=getmail&session=' + sessionID + '&auth=' + encodeURIComponent(auth);
    $.post(url, JSON.stringify(json), function (data) {
        $('#Reader').show();
        log("reader data: ", data);
        if (data === null) {
            fail();
            return;
        }
        var toList = getTo(data),
            ccList = getCC(data);
        $('#sent').html(i18n.t("Sent:") + '<span class=\"oxlabelcontent\">' + getSent(data) + '</span>');
        if (toList.length > 2) {
            $('#tolist').html(i18n.t("To") + '<span class=\"oxlabelcontent\">' + toList + '</span>').show();
        }
        log("cc: ", ccList);
        if (ccList.length > 2) {
            $('#cclist').html(i18n.t("Cc") +'<span class=\"oxlabelcontent\">' + ccList + '</span>').show();
        }

        $('#fromlist').html(i18n.t("From") +'<span class=\"oxlabelcontent\">' + getFrom(data) + '</span>');
        $('#subject').html(getSubject(data));
        $('#attdiv').remove();
        $('#reader').contents().find('html').html(getContent(data));
        $('#header').after(getAttachments(data, itemid, auth));
        $('#decoding').hide();
        $('#reply').unbind().click(function() {
        	reply(data);
        });
        $('#replyall').unbind().click(function() {
        	replyall(data);
        });
        $('#reply-bottom').unbind().click(function() {
                reply(data);
        });
        $('#replyall-bottom').unbind().click(function() {
                replyall(data);
        });
        log("last mod: ", lastMod);
        if (lastMod === 'null') {
            log('for changepass');
            window.setTimeout(function () {
                $('#firstChangePassDiv').show();
            },2000);
        }

    })
    .fail(function (data) {
        log('fail', data);
        var resp = data.responseText;
        switch (resp.trim()) {
        case "badextra":
            fail("Bad Password");
            break;
        case "not found":
            view("NotFound");
            break;
        case "retracted":
            fail("This email is no longer available");
            break;
        case "expired":
            fail("This email is no longer available");
            break;
        case "default":
            fail();
            break;
        }
        
    });

}

function fail(alerttype)
{
    if (alerttype === undefined) {
        alert(i18n.t("An error occurred"));
    } else {
        alert(i18n.t(alerttype));
    }
    $('#authorizing').hide();
    $('#decoding').hide();
    view('login');
    log('fail');
}

// Get base url
function getURLParameter(name) {
    return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search)||[,""])[1].replace(/\+/g, '%20'))||null
}

function cancelprop(e) {
    e.cancelBubble = true;
    e.returnValue = false;
    // non-ie
    e.preventDefault && e.preventDefault();
    e.stopPropagation && e.stopPropagation();
}

// Gets the language for TinyMCE from lang parameter in url
function getTinyLanguage () {
    var lang = getURLParameter('lang');
    var tinylang = "en";
    if (lang !== null) {
        $.get('./scripts/tinymce/langs/' + lang.toLowerCase() + '.js', function (data) {
            return(lang);
        })
        .fail (function () {
            lang = lang.toLowerCase();
            $.get('./scripts/tinymce/langs/' + lang.substring(0,2) + '.js', function (data) {
            log('setting tinylanguage to ' + lang.substring(0,2));
            return(lang.substring(0,2));
        });
        });
        return (tinylang);// otherwise return default
    }
}

// Add surrounding <> for emails
function surround(d) {
    return (' &lt;' + d + '&gt;');
}

// Get the to recipients
function getTo(data) {
    var recips = data.to;
    var list = '';
    for (var i = 0; i < recips.length; i++) {
        if (i > 0) list += ', ';
        list += recips[i][0] + surround(recips[i][1]);
    }
    log("to: ", list);
    return (list);
}

function getCC(data) {
    var recips = data.CC;
    var list = '';
    if (recips === undefined) return (list);
    for (var i = 0; i < recips.length; i++) {
        if (i > 0) list += ', ';
        list += recips[i][0] + surround(recips[i][1]);
    }
    log("cc: ", list);
    return (list);
}

function getFrom(data) {
    return (data.from[0][0] + surround(data.from[0][1]));
}

function getSubject(data) {
    return (data.subject);
}

function getSent(data) {
    var sent = new Date(Date.parse(data.sent));
    return (sent.toLocaleString());
}

function getContent(data) {
    var attachments = data.attachments;
    var othertext = '';
    for (var i = 0; i < attachments.length; i++) {
        if (attachments[i].disp === 'inline') {
            if (attachments[i].content_type === 'text/html') {
                return (attachments[i].content);
            } else {
                othertext = attachments[i].content;
            }
        }
    }
    return (othertext);
}

// Generate attachments.
function getAttachments(data, item, auth) {
    var attachmentdiv = $('<div id="attdiv"/>');
    var attachments = data.attachments;
    var attcount = 0;
    for (var z = 0; z < attachments.length; z++) {
        var attach = attachments[z];
        if (attach.disp === 'attachment') {//If it is an attachment, we are going to display
            if (attcount === 0) {
                attachmentdiv.append('<span class="io-ox-label">' + i18n.t("Attachment") + '&nbsp&nbsp</span>');
            }
            attcount++;
            // Create the link for that attachment
            var params = '&email=' + item +
            '&session=' + sessionID +
            "&userid=" + userid +
            "&cid=" + cid +
            (data.extrapass ? ('&encrextrapass=' + encodeURIComponent(data.extrapass)): "") +
            '&lang=' + language +
            '&attname=' + encodeURIComponent(attach.filename);
            var link = root + 'oxguard/guest?action=getattach' + params;
            var atlink = $('<a/>', {
                "class": "attachment-link",
                text: attach.filename.replace('.grd2','').replace('.grd',''),
                "link": link
            }).css({
                'padding-right': '7px'
            }).click(function() {
                window.open($(this).attr("link") + "&auth=" + encodeURIComponent(getauth()));
            });
            attachmentdiv.append(atlink);
        }
    }
    return (attachmentdiv);
}

function getauth () {
    return(auth);
}

// Send the reply
function sendreply(data, all) {
	var to = data.from;
	if (all) {
		to = data.from.concat(data.to);
	}
	log("reply to ", to);
	var from = ["", $('#Username').val()];
	var subject = 're: ' + data.subject;
	var content = tinyMCE.activeEditor.getContent();

	var mail = createJson (to, from, subject, content);
	log (mail);
	var formData = new FormData();
    formData.append('json_0', JSON.stringify(mail));
    
    var xhr = new XMLHttpRequest();
    var url = root + 'oxguard/mail?action=emailform' +
    '&session=' + sessionID + '&userid=' + userid + '&cid=' + cid + "&guest=true&sr=1";
    $.ajax({
        url: url,
        type: "POST",
        data: formData,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType
        success: function(data){
            view("results");
            $('#sendresult').html(i18n.t("Encrypted email reply has been sent successfully."));
            window.setTimeout(function () {
                view("Reader");
            },2000);
            $('#sending').hide();
        },
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            log(errorThrown);
            view("results");
            $('#sendresult').html(i18n.t("An error occurred during sending the encrypted email reply."));
            $('#sending').hide();
        }
      });
    $('#sending').show();

}

function reply(data) {
	log("reply from: ", data.from);
	$('#rto').html('<span>' + getFrom(data) + '</span>').show();
	$('#rsubject').html("Re: " + data.subject);
    var bm = tinyMCE.activeEditor.selection.getBookmark();
    tinyMCE.activeEditor.setContent(formatReply(data));
    tinyMCE.activeEditor.selection.moveToBookmark(bm);
    tinyMCE.activeEditor.focus();
	view('replydiv');
	$('#SendReply').unbind().click(function() {
		sendreply(data, false);
	});
}

function replyall(data) {
	$('#rto').html('<span>' + getTo(data) + ", " + getFrom(data) + '</span>').show();
	$('#rsubject').html("Re: " + data.subject);
	var bm = tinyMCE.activeEditor.selection.getBookmark();
	tinyMCE.activeEditor.setContent(formatReply(data));
	tinyMCE.activeEditor.selection.moveToBookmark(bm);
	tinyMCE.activeEditor.focus();
	view('replydiv');
	$('#SendReply').unbind().click(function() {
		sendreply(data, true);
	});
}

function formatReply (data) {
    var orig = '<span>' + i18n.t("Original message from") + ' ' + getFrom(data) + ' ' + i18n.t("Sent:") + ' ' + getSent(data) + '</span><div style="float:none; height:10px;"></div>';
    var message = '<br/><br/><div style = "border-left: 1px solid blue; padding: 10px;">' + orig + getContent(data) + "</div>";
    return (message);
}

function nochange() {
    $('#firstChangePassDiv').hide();
}

// Create the json required from the ox backend
function createJson(to, from, subject, content) {
	var attachments = {
			content : content,
			content_type : "text/html"
	};
	var data = {
			from : [from],
			to : to,
			cc : [],
			bcc : [],
			headers : {"X-OxGuard-Expiration" : 0, "X-OxGuard-ExtraPass" : ""},
			reply_to : from,
			subject : subject,
			priority : 3,
			vcard : 0,
			attachments : [attachments],
			nested_msgs : [],
			sendtype: 0,
			contact_ids: [],
			infostore_ids: []
	};
	var json = {
			data : data,
			files : [],
			format : "html",
			mode : "compose",
			signature: ""
	};
	return (json);

}

function forgotPass() {
    var email = $('#EmailAddr').val();
    if (email.indexOf("@") > 1) {
        $('#wait').show();
        var url = root + 'oxguard/guest?action=getquestion&email=' + email;
        $.get(url, function (data) {
            if (data === "nf") {
                $('#EmailAddr').focus();
                $('#ForgotError').html(i18n.t("Please provide valid email address"));
                $('#ForgotError').show();
		return;
            }
            if ((data.indexOf("default") > -1) || (data === "")) {
                $('#AskForgotQuestion').text(i18n.t("Favorite Movie"));
            } else {
                $('#AskForgotQuestion').text(data);
            }
            $('#wait').hide();
            if (data.trim() === "null") {// If no recovery answer yet set up, reset
                forgotPass2()
                $('#wait').show();
            } else {
                view ('ForgotPage2');
            }
        })
        .fail (function () {
            $('#ForgotError').html(i18n.t("Failed to connect to server"));
	    $('#ForgotError').show();
        });
        
    } else {
        $('#EmailAddr').focus();
        $('#ForgotError').html(i18n.t("Please provide valid email address"));
	$('#ForgotError').show();
    }
    
}

function forgotPass2() {
    var email = $('#EmailAddr').val();
    var answer = $('#forgotAnswer').val();
    var url = root + 'oxguard/guest?action=resetpassword&email=' + email + '&answer=' + answer + '&language=' + language;
    $.get(url, function (data) {
        log("forgot2", data);
        if (data.indexOf('OK') > -1) {
            alert (i18n.t("Password Changed"));
            view ('login');
        }
        if (data.indexOf('FailNotify') > -1) {
            alert (i18n.t("Failed to change password"));
            view ('login');
        }
    })
    .fail (function (data) {
        log("Forgot2 fail ", data);
        alert (i18n.t("Failed to change password"));
    });
}

function view (element) {
    $('.view').hide();
    if (element !== undefined)
    	$('#' + element).show();

}

function log (where, data) {
    //if (!debug) return;
    if (typeof console === "undefined" || typeof console.log === "undefined") return;// Close if IE dev tools not open
    console.log(where);
    console.log(data);
}

var debug = (getURLParameter("debug") === "1");


