/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.server;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.IdleConnectionMonitor;


public class OxDbConn {
	private static Logger logger = LoggerFactory.getLogger(OxDbConn.class);
	
    public static CloseableHttpClient httpClient;

    public static PoolingHttpClientConnectionManager cm;
    
    private static boolean resetting = false;
    
    private static IdleConnectionMonitor monitor;

    public static void init() {
        cm = new PoolingHttpClientConnectionManager(10, TimeUnit.MINUTES);
        cm.setMaxTotal(Config.max_total_connections);
        cm.setDefaultMaxPerRoute(Config.max_http_connections);
        HttpHost ox = new HttpHost(Config.OXBackend, Config.ox_backend_port);
        cm.setMaxPerRoute(new HttpRoute(ox), Config.max_http_connections);
        httpClient = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setStaleConnectionCheckEnabled(true).build()).disableCookieManagement().setConnectionManager(cm).build();
        monitor = new IdleConnectionMonitor(cm);
        monitor.start();
        try {
			monitor.join(1000);
		} catch (InterruptedException e) {
			logger.info("HTTP Monitor thread shutdown");
		}
    }

    public static void close() {
        try {
            httpClient.close();
            monitor.shutdown();
            cm.close();
            cm.shutdown();
        } catch (IOException e) {
        	logger.error("Error closing httpClient", e);
        }
    }
    
    public static void reset() {
    	try {
    		if (resetting) return;
    		logger.debug("Resetting connection pool");
    		resetting = true;
    		close();
    		init();
    		Timer resetDelay = new Timer();
    		resetDelay.schedule(new TimerTask() {
    			@Override
    			public void run() {
    				resetting = false;
    				logger.debug("end reset delay");
    			}
    		}, 30000);
    	} catch (Exception ex) {
    		logger.error("Error resetting connection pool ", ex);
    	}
    }

}
