/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.server;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.guard.upseller.Upsell;
import com.openexchange.guard.util.CheckOx;
import com.openexchange.guard.util.Core;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.encr.OffsiteKeys;
import com.openexchange.guard.exceptions.GuardMissingParameter;
import com.openexchange.guard.mail.UploadGuest;
import com.openexchange.guard.ox.InterOx;

public class MainServlet extends HttpServlet {
	
	private static Logger logger = LoggerFactory.getLogger(MainServlet.class);
	
    private final String actionpattern = "action=[a-z0-9]+";

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long start = System.nanoTime();
        String url = request.getRequestURI();
        logger.debug("url:" + url);
        try {
            if (url.contains("/file/") || url.contains("/mail/")) {// File and attachments may have filename attached for browser data. Remove if present
                int i = url.lastIndexOf("/");
                url = url.substring(0, i);
            }
            url = url.substring(url.lastIndexOf("/"));
        } catch (Exception ex) {
            logger.error("Problem with url " + url);
            return;
        }
        String command = request.getQueryString();
        String action = getAction(command);
        logger.info("Action: " + action + " From IP: " + Core.getIP(request));
        com.openexchange.guard.server.OxCookie cookie = new OxCookie(request.getCookies());

        logger.debug("get action " + action);
        logger.debug("command: " + command);
        switch (url) {
        case "/file":
            FileHandler fh2 = new FileHandler();
            if (action.equals("get")) {
            	try {
            		fh2.getFile(request, response, cookie, true);
            	} catch (Exception e) {
                	logger.error("Problem getting decrypting file");
                	handleException (e, request, response);
                }
            		
            }
            if (action.equals("remove")) {
            	try {
            		fh2.removeEncryption(request, response, cookie);
            	} catch (Exception e) {
            		logger.error("Problem removing encryption");
            		handleException (e, request, response);
            	}
            }
            if (action.equals("getshare")) {
            	try {
            		fh2.getShares(request, response, cookie);
            	} catch (Exception e) {
            		logger.error("Problem getting shares");
            		handleException (e, request, response);
            	}
            }
            if (action.equals("getfolder")) {
                fh2.getfolder(request, response, cookie);
            }
            break;
        case "/ping":
        	CheckOx.webCheck(response);
        	break;
        case "/mail":
            MailHandler mh = new MailHandler(cookie, request);
            switch (action) {
           
            case ("getattach"):
            	try {
            		mh.getEncrAttach(request, response, cookie);
            	} catch (Exception e) {
                	logger.error("Problem getting encrypted attachment");
                	handleException (e, request, response);
                }
                break;
            case ("getkey"):
                
                try {
                    mh.getRecipKey(request, response);
                } catch (Exception e) {
                	logger.error("Problem getting key");
                	handleException (e, request, response);
                }
                break;
            case ("count"):
            	try {
            		mh.getReadCount(request, response);
            	} catch (Exception e) {
            		logger.error("Problem getting count");
                	handleException (e, request, response);
                }
                break;
            case ("retract"):
            	try {
            		mh.retractEmail(request, response, cookie);
            	} catch (Exception e) {
            		logger.error("Problem retracting email");
                	handleException (e, request, response);
                }
                break;
            case ("upsell"):
            	try {
            		Upsell.getUpsell(request, response);
            	} catch (Exception e) {
            		logger.error("Problem getting upsell");
                	handleException (e, request, response);
                }
            	break;
            }

            break;
        case "/pgpmail":
            PgpHandler pg = new PgpHandler();
            switch (action) {
            case ("getmail"):
                pg.getPGPemail(request, response, cookie);
                break;

            case ("getkey"):
                pg.getKey(request, response);
                break;
            }
            break;
        case "/guest":
            Guest gst = new Guest();
            switch (action) {
            case ("getattach"):
                try {
                    gst.getEncrAttach(request, response, cookie);
                } catch (Exception e) {
                	logger.error("Error getting guest attachment ", e);
                	handleException (e, request, response);
                }
                break;
            case ("getquestion"):
            	try {	
            		gst.getQuestion(request, response, cookie);
            	 } catch (Exception e) {
                 	logger.error("Error getting guest question for reset ", e);
                 	handleException (e, request, response);
                 }
                break;
            case ("resetpassword"):
            	try {
            		gst.resetPassword(request, response, cookie);
            	} catch (Exception e) {
                 	logger.error("Error doing guest password reset ", e);
                 	handleException (e, request, response);
                 }
                break;
            }
            break;
        case "/interox":
            InterOx iox = new InterOx();
            switch (action) {
            case ("getkey"):
            	try {
            		iox.getKey(request, response);
            	} catch (Exception e) {
                 	logger.error("Error interox get Key ", e);
                 	handleException (e, request, response);
                 }
                break;
            case ("getcount"):
            	try {
            		iox.getReadCount(request, response);
            	} catch (Exception e) {
                 	logger.error("Error interox get count ", e);
                 	handleException (e, request, response);
                 }
                break;
            case ("retract"):
            	try {
            		iox.retract(request, response);
            	} catch (Exception e) {
                 	logger.error("Error interox retract ", e);
                 	handleException (e, request, response);
                 }
                break;
            case ("verify"):
            	try {
            		iox.verifyToken(request, response);
            	} catch (Exception e) {
                 	logger.error("Error interox verify ", e);
                 	handleException (e, request, response);
                 }
                break;
            case ("remshare"):
            	try {
            		iox.deleteshare(request, response);
            	} catch (Exception e) {
                 	logger.error("Error interox remove share ", e);
                 	handleException (e, request, response);
                 }
            }
            break;
        case "/keys":
            OffsiteKeys ok = new OffsiteKeys();
            switch (action) {
            case ("getckey"):
                ok.getCCKey(request, response, cookie);
                break;

            }
            break;
        case "/login":
            Auth auth = new Auth();
            switch (action) {

            case ("logout"):
                try {
                    auth.logout(request, response, cookie);
                } catch (Exception e) {
                	logger.error("Error logging in", e);
                	handleException (e, request, response);
                }
                break;
	        case ("reset"): 
	        	try {
	        		auth.resetPass(request, response, cookie);
	        	} catch (Exception e) {
	        		logger.error("Error resetting", e);
	        		handleException (e, request, response);
	            }
            	break;
	        case ("secondary"):
	        	try {
	        		auth.getSecondaryEmail(request, response, cookie);
	        	} catch (Exception e) {
	        		logger.error("Error getting secondary e-mail", e);
	        		handleException (e, request, response);
	        	}
            }
            break;
        case "/demo":
            if (!Config.demo) {
            	logger.error("Attempted demo reset, but not configured for demo.  Add demo:true to config file is needed");
                break; // This is only to be used in demo servers!!!!
            }
            switch (action) {
            case ("reset"):
                try {
                    DemoClass demo = new DemoClass();
                    demo.Reset(request, response);
                } catch (Exception e) {
                	handleException (e, request, response);
                }
                break;
            }
            break;
        default:
            response.sendError(404);
            break;
        }
        logger.debug("GET processed, time " + Core.gettime(start));
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {

        String url = request.getRequestURI();

        com.openexchange.guard.server.OxCookie cookie = new OxCookie(request.getCookies());
        String command = request.getQueryString();
        String action = getAction(command);
        try {
            url = url.substring(url.lastIndexOf("/"));
        } catch (Exception ex) {
            logger.error("Problem with url " + url);
            return;
        }
        logger.debug("url:" + url);
        logger.debug("delete action: " + action);
        logger.debug("command: " + command);
        switch (url) {
        case "/file":
            FileHandler fh = new FileHandler();
            switch (action) {
            case "remshare":
                fh.removeShare(request, response, cookie);
                break;
            }
            break;
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {

        String url = request.getRequestURI();

        com.openexchange.guard.server.OxCookie cookie = new OxCookie(request.getCookies());
        String command = request.getQueryString();
        String action = getAction(command);
        try {
            url = url.substring(url.lastIndexOf("/"));
        } catch (Exception ex) {
            logger.error("Problem with url " + url);
            return;
        }
        logger.debug("url:" + url);
        logger.debug("put action: " + action);
        logger.debug("command: " + command);
        logger.info("Action: " + action + " From IP: " + Core.getIP(request));
        switch (url) {
        case "/mail":
            MailHandler mh = new MailHandler(cookie, request);
            switch (action) {
            case ("saveattachment"):
            	try {
            		mh.saveDecodedAttach(request, response, cookie);
            	} catch (Exception e) {
            		logger.error("Problem with save attachment " , e);
                	handleException (e, request, response);
                }
                break;
            }
            break;
        case "/file":
            FileHandler fh = new FileHandler();
            switch (action) {
            case ("share"):
                fh.share(request, response, cookie);
                break;
            case ("folderperm"):
                fh.addFolderShare(request, response, cookie);
                break;
            }
            break;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {

        long start = System.nanoTime();
        String url = request.getRequestURI();

        com.openexchange.guard.server.OxCookie cookie = new OxCookie(request.getCookies());
        String command = request.getQueryString();
        String action = getAction(command);
        try {
            url = url.substring(url.lastIndexOf("/"));
        } catch (Exception ex) {
            logger.error("Problem with url " + url);
            return;
        }
        logger.debug("url:" + url);
        logger.debug("post action: " + action);
        logger.debug("command: " + command);
        logger.info("Action: " + action + " From IP: " + Core.getIP(request));
        switch (url) {
        case "/mail":
            // Call mail(action);
            logger.debug("Handle mail");
            MailHandler mh = new MailHandler(cookie, request);
            switch (action) {
            case ("emailform"):
                try {
					mh.incomingEmailForm(request, response);
				} catch (Exception e2) {
					// TODO Auto-generated catch block
					logger.error("Incoming email fail " , e2);
					handleException (e2, request, response);
				}
                break;
            case ("getmail"):
                try {
                    mh.getEncrEmail(request, response, cookie);
                } catch (Exception e) {
                	logger.error("Error with get email ", e);
                	handleException (e, request, response);
                }
                break;
            case ("emaildraftform"):
            	try {
            		mh.incomingDraftForm(request, response);
            	} catch (Exception e) {
                	logger.error("Error with saving draft ", e);
                	handleException (e, request, response);
                }
                break;
            }
            break;
            
        case "/file":
            FileHandler fh = new FileHandler();
            switch (action) {
            case ("encrypt"):
            	try {
            		fh.encryptFile(request, response, cookie);
            	} catch (Exception e) {
                	logger.error("Error encrypting file ", e);
                	handleException (e, request, response);
                }
                break;
        	case ("addextra"): 
        		try {
        			fh.addExtraPassword(request, response, cookie);
        		} catch (Exception e) {
                	logger.error("Error adding extra password ", e);
                	handleException (e, request, response);
                }
            break;
            }

        case "/files":// coming from OX UI Uploader
            FileHandler fh3 = new FileHandler();
            switch (action) {
            case ("new"):
            	try {
            		fh3.downloadFormFromClient(request, response, cookie, false);
            	} catch (Exception e) {
            		logger.error("Error encrypting new file", e);
            		handleException (e, request, response);
            	}
                break;
            case ("update"):
            	try {
            		fh3.downloadFormFromClient(request, response, cookie, true);
            	} catch (Exception e) {
            		logger.error("Error updating file", e);
            		handleException (e, request, response);
            	}
                break;
            }
            break;
        case "/mailattach":
            FileHandler fh2 = new FileHandler();
            try {
            	fh2.downloadFormFromClient(request, response, cookie, false);
            } catch (Exception e) {
        		logger.error("Error mail attach", e);
        		handleException (e, request, response);
        	}
            break;
        case "/guest":
            Guest guest = new Guest();
            switch (action) {
            case ("changepass"):
                guest.ChangePass(request, response, cookie);
                break;
            case ("getmail"):
            	try {
            		guest.GetEmail(request, response, cookie);
            	} catch (Exception e2) {
					logger.error("Error getting guest email", e2);
                	handleException (e2, request, response);
				}
                break;
            case ("upload"):
            	UploadGuest uploader = new UploadGuest();
            	try {
					uploader.incomingEmailForm(request, response, cookie);
				} catch (Exception e2) {
					logger.error("Error uploading for guest", e2);
                	handleException (e2, request, response);
				}
        	}
            break;
        case "/login":
            Auth auth = new Auth();
            switch (action) {

            case ("login"):
                auth.login(request, response, cookie);
                break;
            case ("guest"):
            	try {
            		auth.guestlogin(request, response);
            	} catch (Exception e) {
                	logger.error("Error changing password", e);
                	handleException (e, request, response);
                }
                break;
            case ("changepass"):
                try {
                    auth.changepass(request, response, cookie);
                } catch (Exception e) {
                	logger.error("Error changing password", e);
                	handleException (e, request, response);
                }
                break;
            case ("oxpassreset"):
                try {
                    auth.changepassFromOxRecovery(request, response, cookie);
                } catch (Exception e) {
                	logger.error("Error during password reset", e);
                	handleException (e, request, response);
                }
                break;
            case ("create"):
                try {
                    auth.createKeys(request, response, cookie);
                } catch (Exception e1) {
                    logger.error("Error creating keys", e1);
                    handleException (e1, request, response);
                }

                break;
            case ("changesecondary"):
            	try {
            		auth.changeSecondaryEmail(request, response, cookie);
            	} catch (Exception e) {
                    logger.error("Error changing secondary email", e);
                    handleException (e, request, response);
                }
            	break;
            }
            break;
        case "/settings":
        	GuardSettings guard_settings = new GuardSettings();
        	switch (action) {
        	case ("set"):
        		try {
					guard_settings.setSettings(request, response, cookie);
				} catch (Exception e) {
					logger.error("Unable to set settings " , e);
					handleException (e, request, response);
				}
        	    break;
        	}
           break;
        	
        case "/interox":
            InterOx iox = new InterOx();
            switch (action) {
            case ("saveitem"):
                iox.saveItem(request, response);
                break;
            }
            break;
        case "/keys":
            OffsiteKeys ok = new OffsiteKeys();
            switch (action) {
            case ("changepublic"):
                ok.changePublic(request, response, cookie);
                break;
            }
            break;
        default:
            response.sendError(404);
            break;
        }
        logger.debug("POST action processed, time " + Core.gettime(start));
    }

    private void handleException (Exception ex, HttpServletRequest request, HttpServletResponse response) {
    	String url = request.getRequestURI();
    	Core.sendError(response, ex.getMessage());
    	logger.error("Fail with url: " + url, ex);
    }
    /**
     * Parse action from command string
     * 
     * @param command
     * @return
     */
    private String getAction(String command) {
        String action = "";
        try {
            command = command.toLowerCase();
            if (command.contains("action=")) {
                action = command.substring(command.indexOf("action="));
                if (action.contains("&")) {
                    action = action.substring(0, action.indexOf("&"));
                }
                action = action.substring(7);
            }
        } catch (Exception ex) {
        	logger.error("Problem parsing command: " + command, ex);
        }
        return (action);
    }
    
}
