package com.openexchange.guard.server;

import java.lang.management.ManagementFactory;
import java.text.NumberFormat;

import org.apache.http.pool.PoolStats;

public class GuardServerStats implements GuardServerStatsMBean {

		private final long mb = 1048576;
		public synchronized String getPoolInfo() {
			PoolStats stats = OxDbConn.cm.getTotalStats();
			return ("HTTP pool connections- In Pool : " + stats.getAvailable() + " Active: " + stats.getLeased() + " Hold: " + stats.getPending());
		}
		
		public synchronized String getMemoryInfo() {
			return ("Total: " + NumberFormat.getIntegerInstance().format(getTotalMemory()) + " Used: " + NumberFormat.getIntegerInstance().format(getUsedMemory()) + " Free: " + NumberFormat.getIntegerInstance().format(getFreeMemory()) + " Max: " + NumberFormat.getIntegerInstance().format(getMaxMemory()));
		}
		
		public synchronized int getPoolCount() {
			PoolStats stats = OxDbConn.cm.getTotalStats();
			return (stats.getAvailable());
		}
		
		public synchronized int getPoolActive() {
			PoolStats stats = OxDbConn.cm.getTotalStats();
			return (stats.getLeased());
		}
		
		public synchronized int getPoolWaiting() {
			PoolStats stats = OxDbConn.cm.getTotalStats();
			return (stats.getPending());
		}
		
		public synchronized long getUsedMemory() {
			Runtime runtime = Runtime.getRuntime();
			return (runtime.totalMemory() - runtime.freeMemory());
		}
		
		public synchronized long getFreeMemory() {
			return (Runtime.getRuntime().freeMemory());
		}
		
		public synchronized long getMaxMemory() {
			return (Runtime.getRuntime().maxMemory());
		}
		
		public synchronized long getTotalMemory() {
			return (Runtime.getRuntime().totalMemory());
		}
		
		public int getThreadCount() {
			return(ManagementFactory.getThreadMXBean().getThreadCount());
		}
}
