/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.guard.ox;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.google.gson.JsonObject;
import com.openexchange.guard.database.Access;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;
import com.openexchange.guard.database.RecipKey;
import com.openexchange.guard.encr.GuardKeys;
import com.openexchange.guard.util.Core;


public class Upgrader {
	private static Logger logger = LoggerFactory.getLogger(Upgrader.class);
	
	public static String upgrade (String email) throws Exception {
		Access acc = new Access();
		GuardKeys keys = acc.getKeysFromEmail(email);
		if (keys == null) {
			logger.error("Unable to find guest account " + email);
			return ("Unable to find guest account");
		}
		com.openexchange.guard.database.Utilities util = new com.openexchange.guard.database.Utilities();
        JsonObject userdat = util.getUser(email);
        if (userdat.has(email)) {
            JsonObject user = userdat.get(email).getAsJsonObject();
            int newid = user.get("uid").getAsInt();
            int newcid = user.get("cid").getAsInt();
            if (newid == keys.userid && newcid == keys.contextid) {
            	logger.error("Already upgraded " + email);
    			return ("Already upgraded");
            }
            if (upgrade(keys.userid, keys.contextid, newid, newcid)) {
            	logger.info(email + " Upgraded to OX account");
            	return ("OK");
            } else {
            	logger.error("Error upgrading account " + email);
            	return ("Error upgrading account");
            }
        }
        else {
        	logger.error("No OX account found for " + email);
        	return ("No OX account found for " + email);
        }
	}
	
	public static boolean upgrade (int guest_userid, int guest_cid, int new_id, int new_cid) throws Exception {
		String command = "SELECT * FROM og_encrypted_items AS encr INNER JOIN og_content_keys AS ckeys ON encr.Id = ckeys.ItemId WHERE ckeys.UserId = ? AND ckeys.CID = ?";
		DbCommand com = new DbCommand(command);
		com.addVariables(guest_userid);
		com.addVariables(guest_cid);
		DbQuery db = new DbQuery();
		db.read(com, guest_userid, guest_cid);
		ArrayList<encrItem> items = new ArrayList<encrItem>();
		while (db.next()) {
			encrItem item = new encrItem(db.rs.getString("Id"), db.rs.getString("ContentKey"), db.rs.getInt("UserId"), db.rs.getInt("CID"), db.rs.getInt("Status"),
					db.rs.getInt("Owner"), db.rs.getInt("Owner_cid"), db.rs.getLong("Expiration"), db.rs.getInt("Type"), db.rs.getString("XML"),
					db.rs.getString("Salt"));
			items.add(item);
		}
		db.close();
		if (items.size() > 0) {
			for (encrItem item : items) {
				command = "SELECT XML FROM og_encrypted_items WHERE og_encrypted_items.Id = ? AND Owner = ? AND Owner_cid = ?";
				com = new DbCommand (command);
				com.addVariables(item.ItemId);
				com.addVariables(item.Owner);
				com.addVariables(item.Owner_cid);
				db = new DbQuery();
				db.read(com, item.Owner, item.Owner_cid);
				if (db.next()) {
					String ownerXML = updateShare(guest_userid, guest_cid, new_id, new_cid, db.rs.getString("XML"));
					item.Owner_XML = ownerXML;
				}
			}
		}
		db.close();
		// Begin transaction
		db = new DbQuery();
		for (encrItem item: items) {
			// Add encrypted items to list, may be duplicate if in same database and can ignore
			command = "INSERT INTO og_encrypted_items VALUES (?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE og_encrypted_items.Owner = og_encrypted_items.Owner";
			com = new DbCommand(command);
			com.addVariables(item.ItemId);
			com.addVariables(item.Owner);
			com.addVariables(item.exp);
			com.addVariables(item.type);
			com.addVariables(item.XML);
			com.addVariables(item.Owner_cid);
			com.addVariables(item.Salt);
			db.writeToDB(com, new_cid);
			
			// Insert the content keys for the user, no duplicates
			command = "INSERT INTO og_content_keys VALUES (?, ?, ?, ?, NULL, ?)";
			com = new DbCommand(command);
			com.addVariables(item.ItemId);
			com.addVariables(new_id);
			com.addVariables(item.ContentKey);
			com.addVariables(item.Status);
			com.addVariables(new_cid);
			db.writeToDB(com, new_cid);

			// Need to update the shares list of the XML to new user ids
			command = "UPDATE og_encrypted_items SET XML = ? WHERE og_encrypted_items.Id = ? AND Owner = ? AND Owner_cid = ?";
			com = new DbCommand(command);
			com.addVariables(item.Owner_XML);
			com.addVariables(item.ItemId);
			com.addVariables(item.Owner);
			com.addVariables(item.Owner_cid);
			db.writeToDB(com, item.Owner_cid);
			
		}
		command = "SELECT * FROM og_KeyTable WHERE og_KeyTable.id = ? and cid = ?";
		com = new DbCommand(command);
		com.addVariables(guest_userid);
		com.addVariables(guest_cid);
		db.read(com, guest_userid, guest_cid);
		if (db.next()) {
			String pgpSecret = db.rs.getString("PGPSecret");
			String pgpPublic = db.rs.getString("PGPPublic");
			String rsaPrivate = db.rs.getString("RSAPrivate");
			String rsaPublic = db.rs.getString("RSAPublic");
			String recovery = db.rs.getString("Recovery");
			String salt = db.rs.getString("Salt");
			String email = db.rs.getString("email");
			java.sql.Date lastMod = db.rs.getDate("lastMod");
			String question = db.rs.getString("question");
			String answer = db.rs.getString("answer");
			String misc = db.rs.getString("misc");
			String lang = db.rs.getString("lang");
			String settings = db.rs.getString("settings");
			command = "INSERT INTO og_KeyTable VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			DbCommand com2 = new DbCommand(command);
			com2.addVariables(new_id);
			com2.addVariables(pgpSecret);
			com2.addVariables(pgpPublic);
			com2.addVariables(rsaPrivate);
			com2.addVariables(rsaPublic);
			com2.addVariables(recovery);
			com2.addVariables(salt);
			com2.addVariables(new_cid);
			com2.addVariables(email);
			com2.addVariables(lastMod);
			com2.addVariables(question);
			com2.addVariables(answer);
			com2.addVariables(misc);
			com2.addVariables(lang);
			com2.addVariables(settings);
			DbQuery db2 = new DbQuery();
			db2.writeToDB(com2, new_cid);
			db2.close();
		} else {
			logger.error("Error loading master keys for guest");
		}
		// If finished without errors, then update OG table
		command = "UPDATE og_email SET id = ?, cid = ?, db = 0 WHERE id = ? and cid = ?";
		com = new DbCommand(command);
		com.addVariables(new_id);
		com.addVariables(new_cid);
		com.addVariables(guest_userid);
		com.addVariables(guest_cid);
		db.writeOxGuard(com);
		db.close();
		return (true);
	}


	private static String updateShare (int guest_id, int guest_cid, int new_id, int new_cid, String xml) throws UnsupportedEncodingException, SAXException, IOException, ParserConfigurationException, TransformerException {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	    DocumentBuilder builder = factory.newDocumentBuilder();
	    org.w3c.dom.Document doc = builder.parse(new InputSource(new ByteArrayInputStream(xml.getBytes("utf-8"))));
	    doc.getDocumentElement().normalize();
	    Element share = (Element) doc.getElementsByTagName("share").item(0);
	    NodeList shares = share.getElementsByTagName("u");
	    for (int i = 0; i < shares.getLength(); i++) {// For each of the users, check count
            Element user = (Element) shares.item(i);
            int share_cid = Integer.parseInt(user.getElementsByTagName("c").item(0).getFirstChild().getTextContent());
            int share_userid = Integer.parseInt(user.getElementsByTagName("i").item(0).getFirstChild().getTextContent());
            if ((share_userid == guest_id) && (share_cid == guest_cid)) {
            	user.getElementsByTagName("c").item(0).getFirstChild().setTextContent(Integer.toString(new_cid));
            	user.getElementsByTagName("i").item(0).getFirstChild().setTextContent(Integer.toString(new_id));
            }
	    }
	    xml = Core.getXMLString(doc);
	    
	    return (xml);
	}
}

class encrItem {
	public String ItemId;
	public String ContentKey;
	public int UserId;
	public int CID;
	public int Status;
	public int Owner;
	public int Owner_cid;
	public long exp;
	public int type;
	public String XML;
	public String Salt;
	public String Owner_XML;
	
	public encrItem (String ItemId, String ContentKey,int UserId, int CID, int Status, int Owner, int Owner_cid, long exp, int type, String XML, String Salt) {
		this.ItemId = ItemId;
		this.ContentKey = ContentKey;
		this.UserId = UserId;
		this.CID = CID;
		this.Status = Status;
		this.Owner = Owner;
		this.Owner_cid = Owner_cid;
		this.exp = exp;
		this.type = type;
		this.XML = XML;
		this.Salt = Salt;
	}
}
