package com.openexchange.guard.mail;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.EmailInfo;
import com.openexchange.guard.database.RecipKey;
import com.openexchange.guard.mailcreator.Attachment;
import com.openexchange.guard.mailcreator.Mail;
import com.openexchange.guard.ox.Api;
import com.openexchange.guard.ox.Languages;
import com.openexchange.guard.server.OxCookie;
import com.openexchange.guard.server.Sender;
import com.openexchange.guard.translate.GetText;

public class SendNotice {

private static Logger logger = LoggerFactory.getLogger(SendNotice.class);
	
    OxCookie cookie;
    HttpServletRequest req;
    String sessionId;

    public SendNotice(OxCookie ck, HttpServletRequest rq, String session) {
        cookie = ck;
        req = rq;
        sessionId = session;
    }
    
    /**
     * Send the notice email to our recipients
     * 
     * @param json The original email json
     * @param id The item ID
     * @param ua user agent
     * @param attachments
     */
    public boolean sendEmailNotice(ArrayList<RecipKey> recipients, JsonObject json, String id, String ua, ArrayList<Attachment> attachments, boolean extraEncr, String guest, EmailInfo info, String language, int cid, String guestmessage, String pin, JsonObject oldheader, String sentfolder, String mailId, int templId) {
        Mail mf = new Mail();
        boolean success = true;
        String subject = json.get("subject").getAsString();
        JsonArray from = json.get("from").getAsJsonArray().get(0).getAsJsonArray();
        JsonObject head = new JsonObject();
        head.addProperty("X-OxGuard", true);
        head.addProperty("X-OxGuard-ID", id);
        head.addProperty("Message-ID", mailId);
        if (oldheader.get("In-Reply-To") != null) {
            head.addProperty("In-Reply-To", oldheader.get("In-Reply-To").getAsString());
        }
        if (oldheader.get("References") != null) {
            head.addProperty("References", oldheader.get("References").getAsString());
        }
        if (guest != null) {  // Send as
        	if (!info.senderEmail.equals("")) {
        		head.addProperty("Sender", info.senderEmail);
        	}
        }
        Api ap = new Api(cookie, sessionId, ua);
        if (extraEncr) {
            head.addProperty("X-OxGuard-ExtraPass", true);
        }
        Gson gson = new Gson();
        JsonObject guestHeader = gson.fromJson(head, JsonObject.class);
        guestHeader.addProperty("X-OxGuard-Guest", true);
        guestHeader.addProperty("X-OxGuard-Domain", Config.OXUrl);
        ArrayList<String> failures = new ArrayList<String>(); // A list of failed emails
        for (int i = 0; i < recipients.size(); i++) {
            RecipKey recip = recipients.get(i);

            if ((recip.cid < 0) && !recip.remote) { // If this is a non-ox member, then we're going to send a different email
                JsonObject email = mf.createBlankGuestMail(recip.lang, templId);
                if (email == null)
                    return (false);
                email = mf.addTo(email, recip.name, recip.email, recip.type);
                email = mf.addFrom(email, from.get(0).getAsString(), from.get(1).getAsString());
                email = mf.addSubject(email, subject);
                email = mf.addPlainText(email, guestmessage);
                email.getAsJsonObject("data").add("headers",  guestHeader);
                email = mf.noSave(email);
                try {
					email = mf.addURL(
					    email,
					    "https://" + Config.OXUrl + Config.externalReaderPath + "?email=" + id +
					    "&user=" + URLEncoder.encode(recip.email, "ISO-8859-1") + (extraEncr ? "&extrapass=true" : "") + (Languages.customTemplateExists(
					        templId,
					        "guesttempl.html") ? ("&templid=" + templId) : "") + "&lang=" + recip.lang);
				} catch (UnsupportedEncodingException e) {
					email = mf.addURL(
						    email,
						    "https://" + Config.OXUrl + Config.externalReaderPath + "?email=" + id);
				}
                if (recip.newGuestPass != null) {
                    // This is a new Guest account with a new password, need to send notice to the recipient
                    if (com.openexchange.guard.util.Core.checkFail(ap.sendMail(
                        mf.getPasswordEmail(
                            recip.email,
                            from.get(0).getAsString(),
                            from.get(0).getAsString(),
                            from.get(1).getAsString(),
                            recip.newGuestPass,
                            recip.lang,
                            templId,
                            guestmessage),
                        null).toString())) {
                        failures.add(recip.email);
                    }
                }
                if (cid > 0) { // Check if OX member sending, or non-ox replying
                    if (com.openexchange.guard.util.Core.checkFail(ap.sendMail(email, attachments).toString())) {
                        failures.add(recip.email);
                    }
                } else {
                    Sender send = new Sender();
                    if (!send.send(email, attachments, info.senderEmail, language, mailId)) {
                        failures.add(recip.email);
                    }
                }
            } else {
                JsonObject email = mf.createBlankOutMail(recip.lang, templId);
                if (email == null)
                    return (false);
                email = mf.addTo(email, recip.name, recip.email, recip.type);
                email = mf.addFrom(email, from.get(0).getAsString(), from.get(1).getAsString());
                /*
                if (attachments.size() > 1) {
                    email = mf.addSubject(email, "OXGrd:: " + subject); // Add double :: if has attachments
                } else
                    email = mf.addSubject(email, "OXGrd: " + subject);
                */
                email = mf.addSubject(email, subject);
                email.getAsJsonObject("data").add("headers", head);
                email = mf.addURL(email, "https://" + Config.OXUrl);
                email = mf.noSave(email);
                if (cid > 0) {
                    if (com.openexchange.guard.util.Core.checkFail(ap.sendMail(email, attachments).toString())) {
                        failures.add(recip.email);
                    }
                } else {
                    Sender send = new Sender();
                    if (!send.send(email, attachments, info.senderEmail, language, mailId)) {
                        failures.add(recip.email);
                    }
                }
            }
        }
        if (failures.size() > 0) {// Some recipients have failed for some reason, notify the sender
            JsonObject failmail = mf.createFailureMail();
            failmail = mf.addTo(failmail, from.get(0).getAsString(), from.get(1).getAsString());
            failmail = mf.addFrom(failmail, "Mailer", from.get(1).getAsString());
            failmail = mf.addSubject(failmail, GetText.gettext("Mail delivery failure", language));
            String content = GetText.gettext("Email delivery to the following recipients failed:", language) + ": ";
            for (int f = 0; f < failures.size(); f++) {
                content += failures.get(f) + ", ";
            }
            failmail = mf.setContent(failmail, content);
            success = false;
            if (cid > 0) // We can only direct into inbox with ox users
                logger.debug(ap.saveInBox(failmail, null).toString());
        }
        
        // Let's save to the outbox the email, sent to all recipients.
        JsonObject email = mf.createBlankOutMail(language, templId);
        for (int i = 0; i < recipients.size(); i++) {
            email = mf.addTo(email, recipients.get(i).name, recipients.get(i).email, recipients.get(i).type);
        }
        email = mf.addFrom(email, from.get(0).getAsString(), from.get(1).getAsString());
        // email = mf.addSubject(email, "OXGrd: " + subject);
        email = mf.addSubject(email, subject);
    	if (pin != null) {  // If PIN was used, save in sent email
    		head.addProperty("X-OxGuard-PIN", pin);
    	}
        email.getAsJsonObject("data").add("headers", head);
        email = mf.addURL(email, "https://" + Config.OXUrl);
        if (cid > 0)
            logger.debug(ap.saveSentMail(email, attachments, sentfolder).toString());
        return (success);
    }
    
}
