package com.openexchange.guard.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.openexchange.guard.config.OxConfiguration;
import com.openexchange.guard.database.Access;
import com.openexchange.guard.database.EmailInfo;
import com.openexchange.guard.database.GetPubKey;
import com.openexchange.guard.database.RecipKey;
import com.openexchange.guard.encr.Crypto;
import com.openexchange.guard.encr.DecodedObj;
import com.openexchange.guard.encr.EncrLib;
import com.openexchange.guard.encr.EncryptedObj;
import com.openexchange.guard.exceptions.GuardMissingParameter;
import com.openexchange.guard.mailcreator.Attachment;
import com.openexchange.guard.mailcreator.Mail;
import com.openexchange.guard.ox.Api;
import com.openexchange.guard.server.Auth;
import com.openexchange.guard.server.MailHandler;
import com.openexchange.guard.server.OxCookie;
import com.openexchange.guard.server.UserData;
import com.openexchange.guard.server.Settings.permissions;
import com.openexchange.guard.util.Core;

public class Incoming {

	private static Logger logger = LoggerFactory.getLogger(Incoming.class);
	
    OxCookie cookie;
    HttpServletRequest req;
    String sessionId;

    public Incoming(OxCookie ck, HttpServletRequest rq) {
        cookie = ck;
        req = rq;
        sessionId = rq.getParameter("session");
    }
	
    /**
     * Handle email sent from UI
     * 
     * @param request
     * @param response
     * @throws Exception 
     */
 
	   public void incomingEmailForm(HttpServletRequest request, HttpServletResponse response) throws Exception {
	        FileItemFactory fif = new DiskFileItemFactory();
	        ServletFileUpload sfu = new ServletFileUpload(fif);
	        String itemID = EncrLib.getUUID(); // One itemID for email and it's attachments
	        String salt = EncrLib.getsalt();// Create salt
	        int userid = Core.getIntParameter(request, "userid", true);
	        int cid = Core.getIntParameter(request, "cid", true);
	        String sentfolder = Core.getStringParameter(request, "sentfolder");
	        if (sentfolder == null) sentfolder = "default0/Sent Items";
	        String guest = Core.getStringParameter(request, "guest");
	        if (guest != null) {
	        	if (!guest.toLowerCase().trim().equals("true")) guest = null;
	        }
	        String language = Core.getStringParameter(request, "lang");
	        String guestlanguage = Core.getStringParameter(request, "guestlangauge");
	        String attach_password = Core.getStringParameter(request, "password");// encrypted attachment password
	        String attach_extrapass = Core.getStringParameter(request, "extrapass");  // encrypted attachment extra password
	        String auth = Core.getStringParameter(request, "auth");
	        String pin = null;
	        int templId = Core.getIntParameter(request, "templid");
	        if (language == null)
	            language = "en-US";
	        EmailInfo info = null;
	        String sr = Core.getStringParameter(request, "sr");
	        // If not guest, verify logged in
	        if (guest == null) {
	        	Api ap = new Api(cookie, request);
	        	if (!ap.verifyLogin()) {
	        		logger.error("not logged into ui");
	                Core.sendFail(response, "not authorized");
	                return;
	        	}
	        	   // Load custom template Id for this user
	        } else {
	        	if (sr == null) {  // Reply ID must be sent if not part of UI
	        		logger.error("Reply ID not sent");
	        		Core.sendFail(response, "not authorized");
	                return;
	        	}	
	        	cookie.JSESSIONID = cookie.OxReaderID;
	        	UserData userdata = new UserData(auth, cookie);
	        	cid = userdata.cid;
	        	if (userdata.userid < 0) {
	        		logger.debug("Bad authorization for guest login");
	        		Core.sendFail(response, "not authorized");
	                return;
	        	}
	        	userid = userdata.userid;
	        	
	        }

	        boolean sendPermission = false;
	        // Check for permission for sending email
	        if (guest == null) {
		        if (!Auth.checkPermission(cookie, request, permissions.MAIL)) {
		            // If not permission, check if secure reply
		            if (sr == null) {
		                logger.error("not authorized");
		                Core.sendFail(response, "not authorized");
		                return;
		            }
		        } else sendPermission = true;
	        }
	        if ((sr != null) && !sendPermission) info = new EmailInfo(sr, userid, cid);
	        if (cid < 0) {  // If negative context ID (non-ox user), use the orig senders templates for sending
	        	templId = OxConfiguration.getTemplateId(info.owner_cid, info.owner_id);
	        } else {
	            templId = OxConfiguration.getTemplateId(cid, userid);
	        }
	        
	        Crypto crypt = new Crypto();
	        String contentKey = crypt.createContentKey();

	            ArrayList<Attachment> attachments = new ArrayList<Attachment>();// Get list of all attachments
	            String emaildata = "";
	            String guestmessage = "";
	            List files = sfu.parseRequest(request);
	            sessionId = Core.getStringParameter(request, "session", true);
	            String ua = request.getHeader("User-Agent");
	            Iterator iterator = files.iterator(); // Iterate through attachments
	            while (iterator.hasNext()) {
	                FileItem fi = (FileItem) iterator.next();
	                String name = fi.getFieldName();
	                if (name.startsWith("guest_message")) {
	                    guestmessage = fi.getString("UTF-8");
	                    continue;
	                }
	                if (name.startsWith("pin")) {
	                	pin = fi.getString("UTF-8");
	                	continue;
	                }
	                if (name.startsWith("json")) { // Field name json is the email data (or should be). So get email data
	                    emaildata = fi.getString("UTF-8");
	                } else {
	                    name = fi.getName(); // Otherwise, assume it is an attachment
	                    if (name != null) {// Make sure the name of the file exists, may just be blank field
	                        if (name.trim() != "") {
	                            if (name.lastIndexOf("\\") > -1) {
	                                name = name.substring(name.lastIndexOf("\\"));
	                            }
	                            if (name.lastIndexOf("/") > -1) {
	                                name = name.substring(name.lastIndexOf("/"));
	                            }
	                            ByteArrayOutputStream out = new ByteArrayOutputStream();
	                            InputStream input = fi.getInputStream();
	                            IOUtils.copy(input, out); // Copy stream to byte array
	                            Attachment attach = new Attachment();
	                            attach.content = out.toByteArray(); // Populate attachment data
	                            attach.filename = fi.getName();

	                            attach.type = "grd/" + fi.getContentType().replace("/", "--"); // Add grd prefix
	                            attachments.add(attach); // Add to our array of attachments
	                            out.close();
	                            input.close();
	                        }
	                    }
	                }
	            }
	            if (emaildata != "") { // We must have the basic email data
	                JsonParser jsonParser = new JsonParser(); // Put it into json
	                JsonObject json = (JsonObject) jsonParser.parse(emaildata);
	                if (json.get("attachextra") != null) attach_extrapass = json.get("attachextra").getAsString();
	                if (json.get("attachpassword") != null) attach_password = json.get("attachpassword").getAsString();
	                JsonObject data = json.getAsJsonObject("data");
	                ArrayList<RecipKey> recipients = getUsers(data, userid, cid, guestlanguage, pin); // get the users and populate the recipient keys
	                if (recipients == null) {
	                    logger.error("Unable to get keys for all users");
	                    Core.sendFail(response, "keyproblem");
	                    return;
	                }
	                
	                if (!sendPermission) {
	                	JsonArray from = data.get("from").getAsJsonArray().get(0).getAsJsonArray();
	                	if (!checkReply(from, recipients, info)) {
	                		logger.error("Attempt to reply to users not in original email list");
	                		Core.sendFail(response, "unauth recip");
	                		return;
	                	}
	                }
	                
	                // Encrypt email
	                JsonObject header = data.getAsJsonObject("headers");
	                String extrapass = "";
	                try {
	                	if (header.has("X-OxGuard-ExtraPass")) extrapass = header.get("X-OxGuard-ExtraPass").getAsString();
	                	if (!extrapass.equals("")) {
	                		header.remove("X-OxGuard-ExtraPass");
	                		header.addProperty("X-OxGuard-ExtraPass", "true");
	                	}
	                } catch (Exception e) {
	                    logger.error("Problem getting extra pass " + e.toString());
	                }

	                // Get infostore attachments
	                try {
	                    if (!data.get("infostore_ids").isJsonNull()) {
	                        JsonArray infostores = data.get("infostore_ids").getAsJsonArray();
	                        if (infostores != null) {
	                            for (int i = 0; i < infostores.size(); i++) {
	                                Attachment attach = getInfoAttach(infostores.get(i).getAsJsonObject(), request, cookie);
	                                if (attach != null) 
	                                	attachments.add(attach);
	                            }
	                        }
	                    }
	                } catch (Exception ex2) {
	                    logger.error("Problem extracting infostore items.", ex2);

	                }
	                // Search for inline images, convert to attachments
	                data = getInlineImages (data, attachments, request, cookie);
	                
	                data = getNestedMessages (data, attachments, request, cookie);
	                
	                // Search for attachments that reference a draft email, and aren't actually supplied.
	                data = getDraftAttachments (data, attachments, request, cookie, userid, cid);
	                
	                Gson gson = new Gson();
	                EncrLib encr = new EncrLib();
	                String mailId = "<OxGuard-" + EncrLib.getUUID() + ">";
	                try {
	                    // Let's encrypt the email
	                    long exp = getExpDate(data);
	                    String oxemail = Mail.PrepareOXEmail(data, attachments, exp, mailId);
	                    if (!extrapass.equals("")) {// if extra password specified, then encrypt first with aes
	                        logger.debug("encrypting with extra password");
	                        // oxemail = encr.encryptAES(oxemail, extrapass, itemID, Config.AESKeyLen);
	                        if (extrapass.length() > 30) {
		                		if (extrapass.startsWith("E!")) {
		                			extrapass = encr.decryptRSA(extrapass.substring(2), Core.getPasswordKey());
		                		}
		                	}
	                        if (extrapass != null) oxemail = crypt.addExtraPass(oxemail, extrapass, itemID);
	                    }
	                    String encrypted = crypt.EncryptEmail(userid, cid, recipients, oxemail, exp, 1, "", itemID, contentKey, salt);
	                    if (encrypted == null) {
	                        com.openexchange.guard.util.Core.sendFail(response, "Failed to send");
	                        return;
	                    }
	                    Attachment main = new Attachment();
	                    main.encrContent = crypt.addHeader(encrypted, itemID, -1); // Add the header
	                    main.filename = itemID + ".grd"; // Our email filename is the itemID + .loc
	                    main.type = "text/plain";
	                    attachments.add(main); // Add it to our list of attachments for the email

	                } catch (SQLException e) {
	                    logger.error("Error while trying to encrypt email for item " + itemID, e);
	                    com.openexchange.guard.util.Core.sendFail(response, "Failed to send");
	                    return;

	                }

	                // Encrypt the attachments, using the same content key as for the email.
	                for (int i = 0; i < attachments.size(); i++) {
	                    Attachment attach = attachments.get(i);
	                    if (attach.encrContent == null) {// Make sure this isn't the email
	                        // Check if attachments are encrytped objects

	                        if (com.openexchange.guard.util.Core.isEncrItem(attach.content)) {
	                            try {
	                                logger.debug("already encrypted");
	                                EncryptedObj encrAttach = new EncryptedObj(attach.content);
	                                String decoded = crypt.decodeEncrObj(userid, cid, encrAttach, attach_password);
	                                if (decoded.startsWith("EXTRA")) {
	                                    if (attach_extrapass != null) {
	                                        decoded = crypt.decodeExtraPass(decoded, attach_extrapass, encrAttach.ItemID, encrAttach.keyLength);
	                                    }
	                                }
	                                attach.content = Base64.decode(decoded);
	                            } catch (Exception ex) {
	                                logger.debug("Failed to decode attachments");
	                                com.openexchange.guard.util.Core.sendFail(response, "FailDecodeAttach");
	                                return;
	                            }

	                        }

	                        attach.filename += ".grd";

	                        if (!extrapass.equals("")) {
	                            attach.encrContent = crypt.encrItem(
	                                userid,
	                                cid,
	                                recipients,
	                                crypt.addExtraPass(Base64.toBase64String(attach.content), extrapass, itemID),
	                                getExpDate(data),
	                                2,
	                                "",
	                                itemID,
	                                contentKey,
	                                true,
	                                attach.filename);
	                            // crypt.encrItem(userid, cid, recipients,encr.encryptAES(
	                            // Base64.toBase64String(attach.content),extrapass,itemID, Config.AESKeyLen) , getExpDate(data), 2, "", itemID,
	                            // contentKey, true, attach.filename);
	                            attach.filename = attach.filename.replace(".grd", ".grd2"); // mark the attachment as extra password
	                        } else {
	                            attach.encrContent = crypt.encrItem(
	                                userid,
	                                cid,
	                                recipients,
	                                Base64.toBase64String(attach.content),
	                                getExpDate(data),
	                                2,
	                                "",
	                                itemID,
	                                contentKey,
	                                true,
	                                attach.filename);
	                        }

	                        attachments.set(i, attach);
	                    }
	                }
	                // Send the email link message
	                SendNotice sender = new SendNotice(cookie, request, sessionId);
	                if (sender.sendEmailNotice(
	                    recipients,
	                    data,
	                    itemID,
	                    ua,
	                    attachments,
	                    !(extrapass.equals("")),
	                    guest,
	                    info,
	                    language,
	                    cid,
	                    guestmessage,
	                    pin,
	                    header,
	                    sentfolder,
	                    mailId,
	                    templId)) {
	                    logger.info("Success email send");
	                    // If was draft email, delete it from the draft folder
	                    if (data.has("msgref")) {
	                    	Api ap = new Api(cookie, request);
	                    	ap.deleteDraft(data.get("msgref").getAsString());
	                    }
	                    com.openexchange.guard.util.Core.sendOK(response, "OK");// If OK, send response
	                } else {
	                    com.openexchange.guard.util.Core.sendFail(response, "Failed to send");
	                    logger.debug("Failed to send email");
	                }

	            } else {// Our reply that the email was blank
	                com.openexchange.guard.util.Core.sendOK(response, "No Email Data");
	            }

	    }
	   
	    /**
	     * Get the list of recipients from a json email, and get their keys
	     * 
	     * @param json
	     * @return
	     * @throws Exception
	     */
	    public ArrayList<RecipKey> getUsers(JsonObject json, int senderId, int senderCID, String guestlanguage, String pin) throws Exception {

	        ArrayList<RecipKey> recipients = new ArrayList<RecipKey>();

	        JsonArray recips = json.get("to").getAsJsonArray();
	        String from = json.get("from").getAsJsonArray().get(0).getAsJsonArray().get(1).getAsString();
	        String fromName = json.get("from").getAsJsonArray().get(0).getAsJsonArray().get(0).getAsString();
	        recipients = addUsers(recipients, recips, senderId, senderCID, from, fromName, RecipKey.reciptype.to, guestlanguage, pin);
	        if (recipients == null)
	            return (null);
	        recips = json.get("cc").getAsJsonArray();
	        recipients = addUsers(recipients, recips, senderId, senderCID, from, fromName, RecipKey.reciptype.cc, guestlanguage, pin);
	        if (recipients == null)
	            return (null);
	        recips = json.get("bcc").getAsJsonArray();
	        recipients = addUsers(recipients, recips, senderId, senderCID, from, fromName, RecipKey.reciptype.bcc, guestlanguage, pin);

	        return (recipients);

	    }
	    
	    private ArrayList<RecipKey> addUsers(ArrayList<RecipKey> recipients, JsonArray recips, int senderId, int senderCID, String from, String fromName, RecipKey.reciptype type, String guestlanguage, String pin) throws Exception {
	        for (int i = 0; i < recips.size(); i++) {
	            JsonArray recip = recips.get(i).getAsJsonArray();
	            String email = recip.get(1).getAsString();
	            GetPubKey gk = new GetPubKey();
	            try {
	                RecipKey key = gk.getPubKey(email, senderId, senderCID, from, true, false, guestlanguage, fromName, pin);
	                if (key != null) {
	                    if (key.pubkey == null) {
	                        // Fail to create key
	                        return (null);
	                    }
	                    key.email = email;
	                    key.type = type;
	                    try {
	                        key.name = recip.get(0).getAsString();
	                    } catch (Exception ex) {
	                        key.name = "";
	                        logger.error("No key name set for " + email, ex);
	                    }
	                    recipients.add(key);
	                } else {
	                	return (null);
	                    // No keys found or made
	                }
	            } catch (SQLException e) {
	            	logger.error("SQL error when getting public key", e);
	            } catch (IOException e) {
	            	logger.error("IO error when getting public key", e);
	            }
	        }
	        return (recipients);
	    }
	    

	    private boolean checkReply (JsonArray from, ArrayList<RecipKey> recips, EmailInfo info) {
	    	if (info == null) return(false);
	    	if (recips == null) return(false);
	    	if (!info.fromEmail.toLowerCase().trim().equals(from.get(1).getAsString().toLowerCase().trim())) return(false);
	    	for (int i = 0; i < recips.size(); i++) {
	    		if (!info.recips.contains(recips.get(i).email)) {
	    			if (!info.senderEmail.contains(recips.get(i).email)) return(false);
	    		}
	    	}
	    	return (true);
	    }
	    
	    /*
	     * Get exp date of email
	     */
	    public static long getExpDate(JsonObject email) {
	    	try {
		        JsonObject header = email.get("headers").getAsJsonObject();
		        if (!header.has("X-OxGuard-Expiration")) return(0);
		        int hours = header.get("X-OxGuard-Expiration").getAsInt();
		        if (hours == 0) {
		            return (0);
		        }
		        final long exphours = hours * 60L * 60L * 1000L;
		        Date now = new Date();
		        return (now.getTime() + exphours);
	    	} catch (Exception ex) {
	    		logger.error("Problem getting email expiration date");
	    		return (0);
	    	}
	    }
	    
	    public static Attachment getInfoAttach(JsonObject jsonElement, HttpServletRequest request, OxCookie ck) {
	    	try {
		        int id = jsonElement.get("id").getAsInt();
		        int version = jsonElement.has("version") ? jsonElement.get("version").getAsInt() : -1;
		        int folder = jsonElement.get("folder_id").getAsInt();
		        Api ap = new Api(ck, request);
		        Attachment attach = ap.getInfoStoreAttach(id, folder, version);
		        attach.filename = jsonElement.get("filename").getAsString();
		        return (attach);
	    	} catch (Exception ex) {
	    		logger.error("Unable to get infostore attachment ", ex);
	    		return (null);
	    	}
	    }
	    
	    /**
	     * Get attachments from draft email if any.  Looks for atmsgref for regular emails
	     * @param data
	     * @param attachments
	     * @param request
	     * @return
	     */
	    public static JsonObject getDraftAttachments (JsonObject data, ArrayList<Attachment> attachments, HttpServletRequest request, OxCookie ck, int userid, int cid) {
	    	try {
		    	JsonArray contents = data.get("attachments").getAsJsonArray();
		    	JsonArray newcontents = new JsonArray();
		    	for (int i = 0; i < contents.size(); i++) {
		    		boolean modified = false;
		    		JsonObject att = contents.get(i).getAsJsonObject();
		    		if (att.has("ogAttach")) {
		    			DecodedObj ogAttach = getEncrAttach (att, userid, cid, request, ck);
		    			Attachment decattach = new Attachment();
		    			decattach.content = Base64.decode(ogAttach.decoded64);
		    			decattach.type = att.get("content_type").getAsString();
		    			decattach.filename = att.get("filename").getAsString();
		    			attachments.add(decattach);
		    			modified = true;
		    		} else {
			    		if (att.has("atmsgref")) {
			    			String attid = att.get("id").getAsString();
			    			String item = att.get("atmsgref").getAsString();
			    			int j = item.lastIndexOf("/");
			    			String folder = item.substring(0,j);
			    			int emailid = Integer.parseInt(item.substring(j+1).trim());
			    			Api ap = new Api (ck, request);
							Attachment attach = ap.getPlainAttachment(emailid, attid, folder);
							attach.filename = att.get("filename").getAsString();
							attach.type = att.get("content_type").getAsString();
							attachments.add(attach);
							modified = true;
			    		}
		    		}
		    		if (!modified) newcontents.add(contents.get(i));
		    	}
		    	data.remove("attachments");
		    	data.add("attachments", newcontents);
	    	} catch (Exception ex) {
	    		logger.error("Problems getting attachments from draft email ", ex);
	    	}
	    	return (data);
	    }
	    
	    private static DecodedObj getEncrAttach (JsonObject attach, int userid, int cid, HttpServletRequest request, OxCookie ck) {
	    	
	    	int attachid = attach.get("id").getAsInt();
	    	String filename = attach.get("filename").getAsString();
	    	int emailid = attach.get("parent").getAsJsonObject().get("id").getAsInt();
	    	String folder = attach.get("parent").getAsJsonObject().get("folder_id").getAsString();
	    	String encrextrapass = attach.get("extrapass").getAsString();
	    	String extrapass = null;
	    	String cc = attach.get("cc") == null ? null : attach.get("cc").getAsString();
	    	UserData data = new UserData();;
	    	String epassword = attach.get("epass").getAsString();
            if (epassword != null) {
                Access acc = new Access();
                String token = acc.getToken(ck.JSESSIONID);
                EncrLib enc = new EncrLib();
                data.encr_password = enc.decryptAES(epassword, token);
            } else return (null);
            Attachments att = new Attachments (ck);
	    	DecodedObj decoded = att.decodeAttach(
	                request,
	                null,
	                emailid,
	                userid,
	                attachid,
	                cid,
	                null,
	                filename,
	                request.getParameter("session"),
	                extrapass,
	                encrextrapass,
	                folder,
	                cc,
	                data);
	    	return (decoded);
	    }
	    
	    
	    public static JsonObject getNestedMessages (JsonObject data, ArrayList<Attachment> attachments, HttpServletRequest request, OxCookie ck) {
	    	try {
	    		if (!data.has("nested_msgs")) return (data);
	    		JsonArray nested = data.get("nested_msgs").getAsJsonArray();
	    		for (int i = 0; i < nested.size(); i++) {
	    			JsonObject message = nested.get(i).getAsJsonObject();
	    			String message_ref = message.get("msgref").getAsString();
	    			String subject = message.get("subject").getAsString();
	    			if (subject.trim().length()<1) subject = "eml" + i;
	    			Api ap = new Api (ck, request);
	    			String mime = ap.getMime(message_ref);
	    			Attachment newatt = new Attachment();
	    			newatt.filename = subject + ".eml";
	    			newatt.content = mime.getBytes();
	    			newatt.type = "text/html";
	    			attachments.add(newatt);
	    			MimeParser mparse = new MimeParser(newatt.content);
	    			mparse.ParseAttachments();
	    			mparse.mergeAttachments(attachments);
	    		}
	    		return (data);
	    	} catch (Exception ex) {
	    		logger.error("Error getting nested messages", ex);
	    		return (data);
	    	}
	    }
	    
	    public static JsonObject getInlineImages (JsonObject data, ArrayList<Attachment> attachments, HttpServletRequest request, OxCookie ck) {
	    	try {
		    	JsonArray contents = data.get("attachments").getAsJsonArray();
		    	JsonArray newcontents = new JsonArray();
		    	for (int i = 0; i < contents.size(); i++) {
		    		if (contents.get(i).getAsJsonObject().get("content").isJsonNull()) {
		    			newcontents.add(contents.get(i));
		    		}
		    		else {
		    			JsonObject content = contents.get(i).getAsJsonObject();
		    			String cont = content.get("content").getAsString();
		    			int start = cont.indexOf("<img");
		    			boolean changed = false;
		    			String newcont = new String(cont);
		    			while ((start > 0) && (start < cont.length())) {
		    				int end = cont.indexOf(">", start);
		    				if (end < 0) break;
		    				String image = cont.substring(start, end);
		    				Pattern pattern = Pattern.compile("src=\"[^\"]*");
		    				Matcher match = pattern.matcher(image);
		    				if (match.find()) {
		    					String url = image.substring(match.start() +5, match.end());
		    					if (url.length() > 1) {
			    					Api ap = new Api (ck, request);
			    					Attachment attach = ap.getInlineImage(url);
			    					attach.type = "grd/" + attach.type.replace("/", "--");
			    					if (attach != null) attachments.add(attach);
			    					newcont = newcont.replace(url, "attached");
			    					changed = true;
		    					}
		    				}
		    				start = cont.indexOf("<img ", end);
		    			}
		    			if (changed) {
		        			content.remove("content");
		        			content.addProperty("content", newcont);
		    			}
		    			newcontents.add(content);
		    			}
		    	}
		    	data.remove("attachments");
		    	data.add("attachments", newcontents);
	    	} catch (Exception ex) {
	    		logger.error("Problem retrieving inline images ", ex);
	    	}
	    	return (data);
	    }

	   
}
