/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.encr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class EncryptedObj {
	private static Logger logger = LoggerFactory.getLogger(EncryptedObj.class);
	
    public String ItemID;

    public byte[] content;

    public String name;

    public String content_type;

    public String type;

    public int keyLength;
    
    public int length;

    public EncryptedObj() {

    }

    public EncryptedObj(InputStream in) throws IOException {
        parseInputStream(in);

    }

    public EncryptedObj(byte[] in) throws IOException {
        InputStream inp = new ByteArrayInputStream(in);
        parseInputStream(inp);
        inp.close();

    }

    private void parseInputStream(InputStream in) throws IOException {
        int dat;
        boolean done = false;
        int total = 0;
        int pad = 0;
        StringBuilder head = new StringBuilder();
        while (((dat = in.read()) != -1) && !done) {
            head.append((char) dat);
            if (dat == 45)
                pad++;
            else
                pad = 0;
            if (pad > 4)
                done = true;
            if (total++ > 200)
                done = true;
        }
        while (((dat = in.read()) != -1) && dat == 45) {
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write((char) dat);
        IOUtils.copy(in, out);
        this.content = out.toByteArray();
        // this.ItemID = getID(head.toString());
        parseHeader(head.toString());
        out.flush();
        in.close();
        out.close();
    }

    public String getID(String head) {
        try {
            Pattern p = Pattern.compile("\\bID: [A-F0-9]{8}(?:-[A-F0-9]{4}){3}-[A-Z0-9]{12}\\b", Pattern.CASE_INSENSITIVE);
            Matcher m = p.matcher(head);
            if (m.find()) {
                return (m.group().substring(3).trim());
            }
        } catch (Exception e) {
            logger.error("Error getting id for " + head, e);
        }
        return (null);
    }

    
    public void parseHeader(String head) {
        String[] items = head.split(",");
        for (String item : items) {
            if (item.contains(":")) {
                String[] dat = item.split(":");
                switch (dat[0].trim().toLowerCase()) {
                case "key":
                    this.keyLength = Integer.parseInt(dat[1].trim().replace("-", ""));
                    break;
                case "id":
                    Pattern p = Pattern.compile("\\b[A-F0-9]{8}(?:-[A-F0-9]{4}){3}-[A-Z0-9]{12}\\b", Pattern.CASE_INSENSITIVE);
                    Matcher m = p.matcher(dat[1]);
                    if (m.find()) {
                        this.ItemID = m.group().trim();
                    }
                    break;
                case "len":
                	this.length = Integer.parseInt(dat[1].trim());
                	break;
                }
            }
        }
    }
}
