/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.database;

public class DbStrings {

    public static final String createKeyTable = "CREATE TABLE `og_KeyTable` (`id` int(11) NOT NULL AUTO_INCREMENT, `PGPSecret` varchar(4096) COLLATE utf8_unicode_ci," + "`PGPPublic` varchar(2048) COLLATE utf8_unicode_ci, `RSAPrivate` varchar(3072) COLLATE utf8_unicode_ci, `RSAPublic` varchar(1024) COLLATE utf8_unicode_ci," + " `Recovery` varchar(500) COLLATE utf8_unicode_ci, `Salt` varchar(40) COLLATE utf8_unicode_ci, `cid` int(11) NOT NULL DEFAULT '0'," + " `email` varchar(50) COLLATE utf8_unicode_ci NOT NULL, " + " `lastMod` date DEFAULT NULL, `question` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL, " + " `answer` varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL, `misc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL, `lang`  varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL ," + " `settings` varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL, " + " PRIMARY KEY (`id`,`cid`), " + " KEY `email` (`email`)) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

    public static final String createContentKeyTable = "CREATE TABLE `og_content_keys` ( `ItemId` varchar(38) NOT NULL,  `UserId` int(11) DEFAULT NULL," + " `ContentKey` varchar(400) DEFAULT NULL, `Status` int(11) DEFAULT NULL, `ID` int(11) NOT NULL AUTO_INCREMENT," + " `CID` int(11) DEFAULT NULL, PRIMARY KEY (`ID`), KEY `ID` (`ItemId`)) ENGINE=InnoDB AUTO_INCREMENT=284 DEFAULT CHARSET=utf8;";

    public static final String createEncryptedTable = "CREATE TABLE `og_encrypted_items` ( `Id` varchar(38) NOT NULL,  `Owner` int(11) DEFAULT NULL, " + " `Expiration` bigint(20) DEFAULT NULL, `Type` int(11) DEFAULT NULL, `XML` varchar(10000) DEFAULT NULL, " + " `Owner_cid` int(11) DEFAULT NULL, `Salt` varchar(50) DEFAULT NULL, PRIMARY KEY (`Id`(36))) ENGINE=InnoDB DEFAULT CHARSET=utf8;";

}
