/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.database;

import java.util.ArrayList;

/**
 * Database command structure. Holds the String query command, as well as arraylist of variables, if any
 */
public class DbCommand {

    public String command;

    private ArrayList<Object> variables;

    public boolean resultSet = false;

    public DbCommand() {
        command = "";
        variables = new ArrayList<Object>();
    }

    public DbCommand(String com) {
        command = com;
        variables = new ArrayList<Object>();
    }

    public void addVariables(Object var) {
        variables.add(var);
    }

    /**
     * Format the variables into array list, quotes surrounding string
     * 
     * @return
     */
    public String getVariables() {
        if (variables.size() == 0)
            return ("[]");
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < variables.size(); i++) {
            Object var = variables.get(i);
            if (var == null)
                var = "null";
            if (var.getClass() == java.sql.Date.class) {
            	var = var.toString();
            }
            if (var.getClass() == String.class) {
                String data = (String) var;
                if (data.trim().equals("null")) {
                    sb.append(data);// Commands NULL or NOW are not surrounded with quotes
                } else
                    sb.append("\"" + dbformat((String) var) + "\""); // Otherwise, enclose string in quotes
            } else {
                sb.append(var);
            }
            if (i < (variables.size() - 1))
                sb.append(", ");
        }
        sb.append("]");

        return (sb.toString());
    }

    /**
     * Check all string for database safety
     * 
     * @param data
     * @return
     */
    public static String dbformat(String data) {
        if (data == null)
            return (data);
        data = data.replace("'", "\'");
        data = data.replace("`", "\'");
        data = data.replace("\\", "\\\\");
        data = data.replace("\"", "\\\"");
        return (data);
    }

}
