/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticache.model.CopySnapshotRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CopySnapshotRequestMarshaller
implements Marshaller<Request<CopySnapshotRequest>, CopySnapshotRequest> {
    @Override
    public Request<CopySnapshotRequest> marshall(CopySnapshotRequest copySnapshotRequest) {
        if (copySnapshotRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CopySnapshotRequest> request = new DefaultRequest<CopySnapshotRequest>(copySnapshotRequest, "AmazonElastiCache");
        request.addParameter("Action", "CopySnapshot");
        request.addParameter("Version", "2014-03-24");
        if (copySnapshotRequest.getSourceSnapshotName() != null) {
            request.addParameter("SourceSnapshotName", StringUtils.fromString(copySnapshotRequest.getSourceSnapshotName()));
        }
        if (copySnapshotRequest.getTargetSnapshotName() != null) {
            request.addParameter("TargetSnapshotName", StringUtils.fromString(copySnapshotRequest.getTargetSnapshotName()));
        }
        return request;
    }
}

