/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Iterator;
import junit.framework.TestCase;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

public class RRsetTest
extends TestCase {
    private RRset m_rs;
    Name m_name;
    Name m_name2;
    long m_ttl;
    ARecord m_a1;
    ARecord m_a2;
    RRSIGRecord m_s1;
    RRSIGRecord m_s2;

    public void setUp() throws TextParseException, UnknownHostException {
        this.m_rs = new RRset();
        this.m_name = Name.fromString("this.is.a.test.");
        this.m_name2 = Name.fromString("this.is.another.test.");
        this.m_ttl = 43981L;
        this.m_a1 = new ARecord(this.m_name, 1, this.m_ttl, InetAddress.getByName("192.169.232.11"));
        this.m_a2 = new ARecord(this.m_name, 1, this.m_ttl + 1L, InetAddress.getByName("192.169.232.12"));
        this.m_s1 = new RRSIGRecord(this.m_name, 1, this.m_ttl, 1, 15, 703710L, new Date(), new Date(), 10, this.m_name, new byte[0]);
        this.m_s2 = new RRSIGRecord(this.m_name, 1, this.m_ttl, 1, 15, 703710L, new Date(), new Date(), 10, this.m_name2, new byte[0]);
    }

    public void test_ctor_0arg() {
        RRsetTest.assertEquals((int)0, (int)this.m_rs.size());
        try {
            this.m_rs.getDClass();
            RRsetTest.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.m_rs.getType();
            RRsetTest.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.m_rs.getTTL();
            RRsetTest.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.m_rs.getName();
            RRsetTest.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.m_rs.first();
            RRsetTest.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.m_rs.toString();
            RRsetTest.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Iterator itr = this.m_rs.rrs();
        RRsetTest.assertNotNull((Object)itr);
        RRsetTest.assertFalse((boolean)itr.hasNext());
        itr = this.m_rs.sigs();
        RRsetTest.assertNotNull((Object)itr);
        RRsetTest.assertFalse((boolean)itr.hasNext());
    }

    public void test_basics() throws TextParseException, UnknownHostException {
        this.m_rs.addRR(this.m_a1);
        RRsetTest.assertEquals((int)1, (int)this.m_rs.size());
        RRsetTest.assertEquals((int)1, (int)this.m_rs.getDClass());
        RRsetTest.assertEquals((Object)this.m_a1, (Object)this.m_rs.first());
        RRsetTest.assertEquals((Object)this.m_name, (Object)this.m_rs.getName());
        RRsetTest.assertEquals((long)this.m_ttl, (long)this.m_rs.getTTL());
        RRsetTest.assertEquals((int)1, (int)this.m_rs.getType());
        this.m_rs.addRR(this.m_a1);
        RRsetTest.assertEquals((int)1, (int)this.m_rs.size());
        RRsetTest.assertEquals((int)1, (int)this.m_rs.getDClass());
        RRsetTest.assertEquals((Object)this.m_a1, (Object)this.m_rs.first());
        RRsetTest.assertEquals((Object)this.m_name, (Object)this.m_rs.getName());
        RRsetTest.assertEquals((long)this.m_ttl, (long)this.m_rs.getTTL());
        RRsetTest.assertEquals((int)1, (int)this.m_rs.getType());
        this.m_rs.addRR(this.m_a2);
        RRsetTest.assertEquals((int)2, (int)this.m_rs.size());
        RRsetTest.assertEquals((int)1, (int)this.m_rs.getDClass());
        Record r = this.m_rs.first();
        RRsetTest.assertEquals((Object)this.m_a1, (Object)r);
        RRsetTest.assertEquals((Object)this.m_name, (Object)this.m_rs.getName());
        RRsetTest.assertEquals((long)this.m_ttl, (long)this.m_rs.getTTL());
        RRsetTest.assertEquals((int)1, (int)this.m_rs.getType());
        Iterator itr = this.m_rs.rrs();
        RRsetTest.assertEquals((Object)this.m_a1, itr.next());
        RRsetTest.assertEquals((Object)this.m_a2, itr.next());
        itr = this.m_rs.rrs();
        RRsetTest.assertEquals((Object)this.m_a2, itr.next());
        RRsetTest.assertEquals((Object)this.m_a1, itr.next());
        itr = this.m_rs.rrs();
        RRsetTest.assertEquals((Object)this.m_a1, itr.next());
        RRsetTest.assertEquals((Object)this.m_a2, itr.next());
        this.m_rs.deleteRR(this.m_a1);
        RRsetTest.assertEquals((int)1, (int)this.m_rs.size());
        RRsetTest.assertEquals((int)1, (int)this.m_rs.getDClass());
        RRsetTest.assertEquals((Object)this.m_a2, (Object)this.m_rs.first());
        RRsetTest.assertEquals((Object)this.m_name, (Object)this.m_rs.getName());
        RRsetTest.assertEquals((long)this.m_ttl, (long)this.m_rs.getTTL());
        RRsetTest.assertEquals((int)1, (int)this.m_rs.getType());
        this.m_rs.addRR(this.m_s1);
        RRsetTest.assertEquals((int)1, (int)this.m_rs.size());
        itr = this.m_rs.sigs();
        RRsetTest.assertEquals((Object)this.m_s1, itr.next());
        RRsetTest.assertFalse((boolean)itr.hasNext());
        this.m_rs.addRR(this.m_s1);
        itr = this.m_rs.sigs();
        RRsetTest.assertEquals((Object)this.m_s1, itr.next());
        RRsetTest.assertFalse((boolean)itr.hasNext());
        this.m_rs.addRR(this.m_s2);
        itr = this.m_rs.sigs();
        RRsetTest.assertEquals((Object)this.m_s1, itr.next());
        RRsetTest.assertEquals((Object)this.m_s2, itr.next());
        RRsetTest.assertFalse((boolean)itr.hasNext());
        this.m_rs.deleteRR(this.m_s1);
        itr = this.m_rs.sigs();
        RRsetTest.assertEquals((Object)this.m_s2, itr.next());
        RRsetTest.assertFalse((boolean)itr.hasNext());
        this.m_rs.clear();
        RRsetTest.assertEquals((int)0, (int)this.m_rs.size());
        RRsetTest.assertFalse((boolean)this.m_rs.rrs().hasNext());
        RRsetTest.assertFalse((boolean)this.m_rs.sigs().hasNext());
    }

    public void test_ctor_1arg() {
        this.m_rs.addRR(this.m_a1);
        this.m_rs.addRR(this.m_a2);
        this.m_rs.addRR(this.m_s1);
        this.m_rs.addRR(this.m_s2);
        RRset rs2 = new RRset(this.m_rs);
        RRsetTest.assertEquals((int)2, (int)rs2.size());
        RRsetTest.assertEquals((Object)this.m_a1, (Object)rs2.first());
        Iterator itr = rs2.rrs();
        RRsetTest.assertEquals((Object)this.m_a1, itr.next());
        RRsetTest.assertEquals((Object)this.m_a2, itr.next());
        RRsetTest.assertFalse((boolean)itr.hasNext());
        itr = rs2.sigs();
        RRsetTest.assertTrue((boolean)itr.hasNext());
        RRsetTest.assertEquals((Object)this.m_s1, itr.next());
        RRsetTest.assertTrue((boolean)itr.hasNext());
        RRsetTest.assertEquals((Object)this.m_s2, itr.next());
        RRsetTest.assertFalse((boolean)itr.hasNext());
    }

    public void test_toString() {
        this.m_rs.addRR(this.m_a1);
        this.m_rs.addRR(this.m_a2);
        this.m_rs.addRR(this.m_s1);
        this.m_rs.addRR(this.m_s2);
        String out = this.m_rs.toString();
        RRsetTest.assertTrue((out.indexOf(this.m_name.toString()) != -1 ? 1 : 0) != 0);
        RRsetTest.assertTrue((out.indexOf(" IN A ") != -1 ? 1 : 0) != 0);
        RRsetTest.assertTrue((out.indexOf("[192.169.232.11]") != -1 ? 1 : 0) != 0);
        RRsetTest.assertTrue((out.indexOf("[192.169.232.12]") != -1 ? 1 : 0) != 0);
    }

    public void test_addRR_invalidType() throws TextParseException {
        this.m_rs.addRR(this.m_a1);
        CNAMERecord c = new CNAMERecord(this.m_name, 1, this.m_ttl, Name.fromString("an.alias."));
        try {
            this.m_rs.addRR(c);
            RRsetTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_addRR_invalidName() throws TextParseException, UnknownHostException {
        this.m_rs.addRR(this.m_a1);
        this.m_a2 = new ARecord(this.m_name2, 1, this.m_ttl, InetAddress.getByName("192.169.232.11"));
        try {
            this.m_rs.addRR(this.m_a2);
            RRsetTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_addRR_invalidDClass() throws TextParseException, UnknownHostException {
        this.m_rs.addRR(this.m_a1);
        this.m_a2 = new ARecord(this.m_name, 3, this.m_ttl, InetAddress.getByName("192.169.232.11"));
        try {
            this.m_rs.addRR(this.m_a2);
            RRsetTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_TTLcalculation() {
        this.m_rs.addRR(this.m_a2);
        RRsetTest.assertEquals((long)this.m_a2.getTTL(), (long)this.m_rs.getTTL());
        this.m_rs.addRR(this.m_a1);
        RRsetTest.assertEquals((long)this.m_a1.getTTL(), (long)this.m_rs.getTTL());
        Iterator itr = this.m_rs.rrs();
        while (itr.hasNext()) {
            Record r = (Record)itr.next();
            RRsetTest.assertEquals((long)this.m_a1.getTTL(), (long)r.getTTL());
        }
    }

    public void test_Record_placement() {
        this.m_rs.addRR(this.m_a1);
        this.m_rs.addRR(this.m_s1);
        this.m_rs.addRR(this.m_a2);
        Iterator itr = this.m_rs.rrs();
        RRsetTest.assertTrue((boolean)itr.hasNext());
        RRsetTest.assertEquals((Object)this.m_a1, itr.next());
        RRsetTest.assertTrue((boolean)itr.hasNext());
        RRsetTest.assertEquals((Object)this.m_a2, itr.next());
        RRsetTest.assertFalse((boolean)itr.hasNext());
        itr = this.m_rs.sigs();
        RRsetTest.assertTrue((boolean)itr.hasNext());
        RRsetTest.assertEquals((Object)this.m_s1, itr.next());
        RRsetTest.assertFalse((boolean)itr.hasNext());
    }

    public void test_noncycling_iterator() {
        this.m_rs.addRR(this.m_a1);
        this.m_rs.addRR(this.m_a2);
        Iterator itr = this.m_rs.rrs(false);
        RRsetTest.assertTrue((boolean)itr.hasNext());
        RRsetTest.assertEquals((Object)this.m_a1, itr.next());
        RRsetTest.assertTrue((boolean)itr.hasNext());
        RRsetTest.assertEquals((Object)this.m_a2, itr.next());
        itr = this.m_rs.rrs(false);
        RRsetTest.assertTrue((boolean)itr.hasNext());
        RRsetTest.assertEquals((Object)this.m_a1, itr.next());
        RRsetTest.assertTrue((boolean)itr.hasNext());
        RRsetTest.assertEquals((Object)this.m_a2, itr.next());
    }
}

