package com.openexchange.guard.server;

import java.security.Security;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

import com.openexchange.guard.config.Config;
import com.openexchange.guard.setup.MasterPasswordCreator;
import com.openexchange.guard.setup.OxDatabaseCreateor;
import com.openexchange.guard.setup.Repair;

public class HandleArgs {

	public static boolean handle (String [] args) {
		
		if (args.length == 0) return (false);
		Security.addProvider(new BouncyCastleProvider());
		OxDbConn.init();
		switch (args[0]) {
		case "init":
			System.out.println("init called");
        	String user = System.getProperty("user.name");
        	if (!user.toLowerCase().contains("root")) {
        		System.out.println("Shows running as " + user);
        		System.out.println("Must run as root.  Sure you want to continue? \"yes\" to continue.");
        		String response = System.console().readLine();
        		if (!response.equals("yes")) return(true);
        	}
        	
			if (Config.mysqlUsername.length() < 2) {
				System.out.println("Set up configuration file first");
				return(true);
			}
			MasterPasswordCreator cf = new MasterPasswordCreator();
			if (cf.createPasswordFile()) {
				OxDatabaseCreateor cr = new OxDatabaseCreateor();
	            if (cr.create(Config.version)) {
	            	System.out.println("done.  Service not yet started");
	            } else {
	            	System.out.println("Fail.  See log files");
	            }
			}
			cf.setPermissions();
			
            
            return(true);
		case "reset":
			if (args.length < 2) {
				System.out.println("Must include email address");
				return (true);
			}
			String email = args[1];
			if (com.openexchange.guard.validator.EmailValidator.validate(email)) {
				Auth auth = new Auth();
				try {
					auth.resetPass(email);
				} catch (Exception e) {
					System.out.println("FAILED");
					e.printStackTrace();
				}
			} else {
				System.out.println("Bad email address");
			}
			return(true);
		case "repairshard":
			String userid = System.getProperty("user.name");
        	if (!userid.toLowerCase().contains("root")) {
        		System.out.println("Shows running as " + userid);
        		System.out.println("Must run as root.  Exiting...");
        		return(true);
        	}
        	try {
				Repair.repairShard();
			} catch (Exception e) {
				e.printStackTrace();
			}
        	return(true);
		default:
			System.out.println("Usage: ./guard arg");
			System.out.println("Possible arguments are:");
			System.out.println("init: Initialize the database for first use");
			System.out.println("repairshard: Repairs current database shard");
			System.out.println("reset: resets the specified email and sends new password to user");
			System.out.println("       eg. guard reset john@somewhere.com");
			break;
		}
		return(true);
	}
}
