/* This file has been generated by ox-ui-module generator.
 * Please only apply minor changes (better no changes at all) to this file
 * if you want to be able to run the generator again without much trouble.
 *
 * If you really have to change this file for whatever reason, try to contact
 * the core team and describe your use-case. May be, your changes can be
 * integrated into the templates to be of use for everybody.
 */
'use strict';

module.exports = function (grunt) {

    var fs = require('fs');
    var path = require('path');
    function newestImport(theme) {
        return ['apps/themes/mixins.less', 'apps/themes/definitions.less', path.join('apps/themes/', theme, 'definitions.less')]
            .filter(fs.existsSync)
            .map(fs.statSync)
            .reduce(function (acc, stat) {
                return (acc < stat.mtime) ? stat.mtime : acc;
            }, 0);
    }

    function checkForNewerImports(lessFile, mTime, theme, include) {
        if (newestImport(theme) > mTime) {
            include(true);
            return;
        }
        var data = grunt.file.read(lessFile),
            lessDir = path.dirname(lessFile),
            regex = /@import "(.+?)(\.less)?";/g,
            shouldInclude = false,
            match;

        while (!shouldInclude && (match = regex.exec(data)) !== null) {
            // All of my less files are in the same directory,
            // other paths may need to be traversed for different setups...
            var importFile = path.join(lessDir, match[1] + '.less');
            if (grunt.file.exists(importFile)) {
                var stat = fs.statSync(importFile);
                if (stat.mtime > mTime) {
                    shouldInclude = true;
                }
            }
        }
        include(shouldInclude);
    }

    grunt.config.merge({
        newer: {
            options: {
                override: function (detail, include) {
                    if (detail.task === 'less') {
                        // call include with `true` if there are newer imports
                        checkForNewerImports(detail.path, detail.time, detail.target, include);
                    } else {
                        include(false);
                    }
                }
            }
        }
    });

    grunt.loadNpmTasks('grunt-newer');
};
