/* This file has been generated by ox-ui-module generator.
 * Please only apply minor changes (better no changes at all) to this file
 * if you want to be able to run the generator again without much trouble.
 *
 * If you really have to change this file for whatever reason, try to contact
 * the core team and describe your use-case. May be, your changes can be
 * integrated into the templates to be of use for everybody.
 */
'use strict';

module.exports = function (grunt) {

    var fs = require('fs');
    var path = require('path');
    var async = require('async');

    function newestImport(theme) {
        return ['apps/themes/mixins.less', 'apps/themes/definitions.less', path.join('apps/themes/', theme, 'definitions.less')]
            .filter(fs.existsSync)
            .map(fs.statSync)
            .reduce(function (acc, stat) {
                return (acc < stat.mtime) ? stat.mtime : acc;
            }, 0);
    }

    grunt.config.merge({
        newer: {
            options: {
                override: function (details, include) {
                    if (details.task === 'less') {
                        var theme = /.*\/(.*)\+/.exec(details.target) || details.target;
                        if (theme !== details.target) theme = theme[1];
                        if (newestImport(theme) > details.time) {
                            include(true);
                            return;
                        }
                        var checkFileForModifiedImports = async.memoize(function (filepath, fileCheckCallback) {
                            fs.readFile(filepath, 'utf8', function (error, data) {
                                var directoryPath = path.dirname(filepath);
                                var regex = /@import (?:\([^)]+\) )?"(.+?)(\.less)?"/g;
                                var match;

                                function checkNextImport() {
                                    if ((match = regex.exec(data)) === null) {
                                        return fileCheckCallback(false); // all @import files has been checked.
                                    }

                                    var importFilePath = path.join(directoryPath, match[1] + '.less');
                                    fs.exists(importFilePath, function (exists) {
                                        if (!exists) { // @import file does not exists.
                                            return checkNextImport(); // skip to next
                                        }

                                        fs.stat(importFilePath, function (error, stats) {
                                            if (stats.mtime > details.time) { // @import file has been modified, -> include it.
                                                fileCheckCallback(true);
                                            } else {
                                                // @import file has not been modified but, lets check the @import's of this file.
                                                checkFileForModifiedImports(importFilePath, function (hasModifiedImport) {
                                                    if (hasModifiedImport) {
                                                        fileCheckCallback(true);
                                                    } else {
                                                        checkNextImport();
                                                    }
                                                });
                                            }
                                        });
                                    });
                                }

                                checkNextImport();
                            });
                        });
                        checkFileForModifiedImports(details.path, function (found) {
                            include(found);
                        });
                    } else {
                        include(false);
                    }
                }
            }
        }
    });

    grunt.loadNpmTasks('grunt-newer');
};
