  /**
   * Creates a list from an observable sequence.
   * @returns An observable sequence containing a single element with a list containing all the elements of the source sequence.  
   */
  observableProto.toArray = function () {
    var self = this;
    return new AnonymousObservable(function(observer) {
      var arr = [];
      return self.subscribe(
        arr.push.bind(arr),
        observer.onError.bind(observer),
        function () {
          observer.onNext(arr);
          observer.onCompleted();
        });
    });
  };
