  var AnonymousSubject = Rx.AnonymousSubject = (function (__super__) {
    inherits(AnonymousSubject, __super__);

    function AnonymousSubject(observer, observable) {
      this.observer = observer;
      this.observable = observable;      
      __super__.call(this, this.observable.subscribe.bind(this.observable));
    }

    addProperties(AnonymousSubject.prototype, Observer, {
      onCompleted: function () {
        this.observer.onCompleted();
      },            
      onError: function (exception) {
        this.observer.onError(exception);
      },            
      onNext: function (value) {
        this.observer.onNext(value);
      }
    });

    return AnonymousSubject;
  }(Observable));
