/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.obs.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * {@link Project}
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public final class Project {

    public static final Project CENTOS_5 = new Project("CentOS:CentOS-5");
    public static final Project DEBIAN_SQUEEZE = new Project("Debian:Squeeze");
    public static final Project DEBIAN_LENNY = new Project("Debian:Lenny");
    public static final Project DEBIAN_WHEEZY = new Project("Debian:Wheezy");
    public static final Project RHEL_5 = new Project("RedHat:RHEL-5");
    public static final Project RHEL_6 = new Project("RedHat:RHEL-6");
    public static final Project RHEL_7 = new Project("RedHat:RHEL-7");
    public static final Project SLES_11 = new Project("SUSE:SLE-11");

    private final String name;
    private final String title;
    private final String person;
    private String buildConfiguration = null;

    private final Set<String> disabledRepositories = new HashSet<String>();

    private final List<Repository> repositories = new ArrayList<Repository>();

    public Project(String name) {
        this(name, name, null);
    }

    public Project(String name, String title, String person) {
        super();
        this.name = name;
        this.title = title;
        this.person = person;
    }

    public String getName() {
        return name;
    }

    public String getTitle() {
        return title;
    }

    public String getPerson() {
        return person;
    }

    public String getBuildConfiguration() {
        return buildConfiguration;
    }

    public void setBuildConfiguration(final String buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    public void addDisabledRepository(String repository) {
        disabledRepositories.add(repository);
    }

    public String[] getDisabledRepositories() {
        return disabledRepositories.toArray(new String[disabledRepositories.size()]);
    }

    public void addRepository(final Repository repository) {
        repositories.add(repository);
    }

    public Repository[] getRepositories() {
        return repositories.toArray(new Repository[repositories.size()]);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        return result;
    }

    @Override
    public boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Project other = (Project) obj;
        if (name == null) {
            if (other.name != null) {
                return false;
            }
        } else if (!name.equals(other.name)) {
            return false;
        }
        return true;
    }
}
