/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.util.custom.i18n;

import java.util.Objects;
import com.google.common.base.MoreObjects;
import com.openexchange.annotation.Nullable;
import com.openexchange.exception.OXException;

/**
 * 
 * {@link InvalidPropertyTranslation}
 *
 * @author <a href="mailto:pascal.bleser@open-xchange.com">Pascal Bleser</a>
 * @since v7.8.2
 */
public class InvalidPropertyTranslation implements PropertyTranslation {
    private final String name;
    private final OXException error;
    public InvalidPropertyTranslation(final String name, final OXException error) {
        this.name = name;
        this.error = error;
    }
    @Override
    public boolean isValid() {
        return false;
    }
    @Override
    public String name() {
        return name;
    }
    @Override
    public String get(@Nullable String lang) throws OXException {
        throw error;
    }
    @Override
    public int hashCode() {
        return Objects.hash(name, error);
    }
    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final InvalidPropertyTranslation other = (InvalidPropertyTranslation) obj;
        return Objects.equals(name, other.name)
            && Objects.equals(error, other.error)
        ;
    }
    @Override
    public @Nullable String toString() {
        return MoreObjects.toStringHelper(this)
        .add("name", name)
        .add("error", error)
        .toString();
    }
}
