/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.util.custom.base;

import com.openexchange.annotation.Nullable;

/**
 * Resolves placeholders into values, if possible.
 */
public interface PlaceholderResolver {
    /**
     * Locate and return a value for the specified {@code placeholder},
     * or return {@code null} if it cannot be resolved.
     * 
     * @param placeholder the placeholder for which to find a value
     * @return the value for the placeholder, or {@code null} if not
     *  value can be found
     * @throws Exception
     */
    @Nullable String resolve(final String placeholder) throws Exception;
}
