/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.util.activator.impl;

import static com.openexchange.util.custom.base.NullUtil.notNull;
import java.lang.reflect.Constructor;
import java.util.Dictionary;
import java.util.Set;


import javax.annotation.concurrent.ThreadSafe;
import org.osgi.framework.BundleContext;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.openexchange.annotation.Nullable;
import com.openexchange.osgi.ServiceListing;
import com.openexchange.osgi.ServiceSet;
import com.openexchange.util.activator.ServiceDependencyResolver;
import com.openexchange.util.activator.ServiceRegistrationHandler;

/**
 * This abstract service tracker can wait for some service and register another one if all become available.
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 * @author <a href="mailto:pascal.bleser@open-xchange.com">Pascal Bleser</a>
 */
@ThreadSafe
public class ServiceAwareDependentServiceRegisterer<S, T extends S> extends InstanceFactoryServiceAwareDependentServiceRegistererTemplate<S, T> {

    private final @Nullable ServiceRegistrationHandler<T> serviceRegistrationHandler;        
    private final Constructor<T> constructor;
    
    public ServiceAwareDependentServiceRegisterer(final BundleContext context,
        final ImmutableSet<Class<?>> serviceTypes,
        final Class<T> serviceInstanceClass,
        final Dictionary<String, ?> properties,
        final Set<MandatoryServiceDependency<?>> mandatoryServices,
        final Set<OptionalServiceDependency<?>> optionalServices,
        final ImmutableMap<Class<?>, ServiceSet<?>> serviceSets,
        final ImmutableMap<Class<?>, ServiceListing<?>> serviceListings,
        final Set<String> propertiesOfInterest,
        final Constructor<T> constructor,
        final @Nullable ServiceRegistrationHandler<T> serviceRegistrationHandler) {
        super(context, serviceTypes, notNull(serviceInstanceClass.getName()),
            properties,
            mandatoryServices,
            optionalServices,
            serviceSets,
            serviceListings,
            propertiesOfInterest
        );
        this.serviceRegistrationHandler = serviceRegistrationHandler;
        this.constructor = constructor;
    }
    
    @Override
    protected T createInstance(final ServiceDependencyResolver resolver) throws Exception {
        return RegistrationTools.createInstance(
            serviceInstanceName,
            constructor,
            serviceTypes,
            resolver,
            serviceRegistrationHandler
        );
    }
}
