/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.session.sync;

import java.io.Serializable;
import com.openexchange.usm.api.session.assets.SessionID;
import com.openexchange.usm.session.impl.SessionImpl;

/**
 * 
 * @author afe
 *
 */
public class OXDataCacheID implements Serializable {
	private final SessionID _sessionID;
	private final String _folderID;

	/**
	 * Constructor used to identify folder hierarchy
	 * @param session
	 */
	public OXDataCacheID(SessionImpl session) {
		this(session, null);
	}

	/**
	 * Constructor used to identify content of a folder.
	 * 
	 * @param session
	 * @param folderID
	 */
	public OXDataCacheID(SessionImpl session, String folderID) {
		_sessionID = session == null ? null : session.getCompleteSessionID().getSessionID();
		_folderID = folderID;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((_folderID == null) ? 0 : _folderID.hashCode());
		result = prime * result + ((_sessionID == null) ? 0 : _sessionID.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof OXDataCacheID))
			return false;
		OXDataCacheID other = (OXDataCacheID) obj;
		if (_folderID == null) {
			if (other._folderID != null)
				return false;
		} else if (!_folderID.equals(other._folderID))
			return false;
		if (_sessionID == null) {
			if (other._sessionID != null)
				return false;
		} else if (!_sessionID.equals(other._sessionID))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return String.valueOf(_sessionID) + ':' + _folderID;
	}
}
