/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.session.jmx;


public interface USMSessionInformationMBean {

    String SESSION_DOMAIN = "com.openexchange.usm.session";

    int getActiveSessionCount();

    int getWaitForChangesEmailPullDelay();

    void setWaitForChangesEmailPullDelay(int value);

    int getWaitForChangesEmailMinPullDelay();

    void setWaitForChangesEmailMinPullDelay(int value);

    int getMaxSyncStatesInDB();

    void setMaxSyncStatesInDB(int states);

    String[] listActiveSessions();

    String[] getPropertiesOfActiveSessions(int cid, int id, String user, String protocol, String device, String field);

    String updatePropertiesOfActiveSessions(int cid, int id, String user, String protocol, String device, String field, String value);

    String[] getPropertiesOfAllSessions(int cid, int id, String protocol, String device, String field);

    String[] updatePropertiesOfAllSessions(int cid, int id, String protocol, String device, String field, String value);

    int getUSMSesssionCacheInactivityTimeout();

    void setUSMSesssionCacheInactivityTimeout(int timeout);

    int getSyncStateCacheInactivityTimeout();

    void setSyncStateCacheInactivityTimeout(int timeout);

    int getTotalUSMSessionsInMemory();

    int getTotalSyncStatesInMemory();

    void clearCacheCounters();

    int getNewUSMSessionsInMemory();

    int getUSMSessionsRemovedDueToInactivity();

    int getUSMSessionsRemovedByJVM();

    int getSyncStatesSavedToDatabase();

    int getSyncStatesLoadedFromDatabase();

    int getSyncStatesRemovedDueToInactivity();
    
    int getMaxTotalConnections();
    
    int getConnectionsInUse();
}
