/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.session.cache;

import java.io.Serializable;

/**
 * {@link MemorySyncStateCacheEntry}: Contains one cached SyncState with its associated syncid (timestamp)
 * 
 * @author <a href="mailto:afe@microdoc.de">Alexander Feess</a>
 */
public class MemorySyncStateCacheEntry {

    private final long _timestamp;

    private final Serializable[][] _data;

    private long _lastAccess;

    public MemorySyncStateCacheEntry(long timestamp, Serializable[][] data) {
        _timestamp = timestamp;
        _data = data;
        touch();
    }

    public long getTimestamp() {
        return _timestamp;
    }

    public Serializable[][] getData() {
        touch();
        return _data;
    }

    public long getLastAccess() {
        return _lastAccess;
    }

    public void touch() {
        _lastAccess = System.currentTimeMillis();
    }
}
