/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.ox_event.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.service.event.EventConstants;
import org.osgi.service.event.EventHandler;
import com.openexchange.usm.api.session.SessionManager;
import com.openexchange.usm.ox_event.impl.OXEventManagerImpl;
import com.openexchange.usm.util.AbstractUSMActivator;

/**
 * {@link OXEventManagerActivator}
 * 
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class OXEventManagerActivator extends AbstractUSMActivator {

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#getNeededServices()
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] { SessionManager.class };
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#register(org.osgi.framework.BundleContext)
     */
    @Override
    protected void register() {
        SessionManager sessionManager = (SessionManager) context.getService(presentServices.get(SessionManager.class));
        OXEventManagerImpl oxEventManager = new OXEventManagerImpl();
        oxEventManager.addEventListener(sessionManager);

        final Dictionary<String, Object> serviceProperties = new Hashtable<String, Object>(1);
        String[] eventTopics = {
            "com/openexchange/groupware/*", "com/openexchange/remote/*", "com/openexchange/push/*",
            "com/openexchange/push", "com/openexchange/mailaccount/changeddefaultfolders" };
        serviceProperties.put(EventConstants.EVENT_TOPIC, eventTopics);

        registerService(EventHandler.class, oxEventManager, serviceProperties);
        LOG.info("OX Event Manager registered.");
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#unregister(org.osgi.framework.BundleContext)
     */
    @Override
    protected void unregister() {
        LOG.info("OX Event Manager unregistered.");
    }
}
