/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.mimemail;

/**
 * This class contains the array of fields, which can be not stored direct in mail content type. 
 * This fields must be stored extra.
 * @author ibr
 *
 */

public class ExternalMailContentTypeFields {
	
	private static final String[] EXTERNAL_FIELDS = {
		"user", "headers", "body", 	"received_date", "smime_body_data", "tempid"
	};

	public static int getFieldIndex(String name) {
		for(int i = 0; i < EXTERNAL_FIELDS.length; i++){
		   if (EXTERNAL_FIELDS[i].equals(name))
			   return i;
		}
		return -1;
	}
	
	public static String[] getFields() {
		return EXTERNAL_FIELDS;
	}
}
