/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
/*
 * Copyright (C) 2009 MicroDoc GmbH, Munich, Germany
 */

package com.openexchange.usm.connector.commands;

public enum ErrorStatusCode {

    // Specific error codes for MoveItems command

    /**
     * Move Items destination doesn't exist on the server.
     */
    DESTINATION_NOT_EXIST,

    /**
     * Move Items source doesn't exist on the server.
     */
    SOURCE_NOT_EXIST,

    /**
     * No create objects permission in the destination folder (Move Items) for all objects
     */
    DESTINATION_NO_PERMISSION,

    /**
     * No delete permission in the source folder (Move Items) for all objects
     */
    SOURCE_NO_PERMISSION_ALL_OBJECTS,

    /**
     * No delete permission in the source folder (Move Items) for own objects
     */
    SOURCE_NO_PERMISSION_OWN_OBJECTS,

    // Common error codes

    /**
     * Other error.
     */
    OTHER,

    /**
     * No data object has been found for the given UUID
     */
    UNKNOWN_UUID,

    // Specific error codes for SyncInit/SyncUpdate command

    /**
     * No create permissions for objects in the folder or for a sub-folder with the given parent folder
     */
    NO_CREATE_PERMISSION,

    /**
     * No change permissions for objects in the folder or for a given folder
     */
    NO_CHANGE_PERMISSION,

    /**
     * No delete permissions for objects in the folder or for a given folder
     */
    NO_DELETE_PERMISSION,

    /**
     * A PIM attachment couldn't be created in the OX server
     */
    PIM_ATTACHMENT_CREATION_FAILED,

    /**
     * A folder could not be created because its parent folder is not accessible (i.e. it probably has been deleted)
     */
    PARENT_FOLDER_NOT_FOUND,

    /**
     * A mail folder could not be found on the server.
     */
    MAIL_FOLDER_NOT_FOUND,

    /**
     * Some problem with permissions which can not be uniquely determined based on the permission flags.
     */
    PERMISSION_DENIED_BY_SERVER,

    /**
     * The UID (calendar/tasks) already exists on server and can not be created again.
     */
    UID_ALREADY_EXISTS,

    /**
     * A PIM attachment couldn't be created in the OX server because of a limit on the number of attachments to an object
     */
    PIM_ATTACHMENT_CREATION_DENIED_COUNT,

    /**
     * A PIM attachment couldn't be created in the OX server because of a limit on the maximum size of all attachments for an object
     */
    PIM_ATTACHMENT_CREATION_DENIED_SIZE,

    /**
     * The client requested multiple operations on the same UUID. This code will be reported for all operations with that UUID, and none
     * will be executed
     */
    MULTIPLE_OPERATIONS_ON_SAME_UUID,
    
    /**
     * The client requested a move for an object that is not existing any more in the source folder at the server (was moved or deleted by another client). 
     */
    OBJECT_DOES_NOT_EXIST_IN_SOURCE;

    public int getStatusCode() {
        return ordinal() + 1;
    }
    
    public boolean isAttachmentError() {
        return this == ErrorStatusCode.PIM_ATTACHMENT_CREATION_FAILED || this == PIM_ATTACHMENT_CREATION_DENIED_COUNT || this == PIM_ATTACHMENT_CREATION_DENIED_SIZE;
    }
}
