/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.cache.ox_adapter.osgi;

import com.openexchange.caching.CacheService;
import com.openexchange.usm.api.cache.CacheManager;
import com.openexchange.usm.cache.ox_adapter.CacheManagerAdapter;
import com.openexchange.usm.util.AbstractUSMActivator;

/**
 * {@link CacheAdapterActivator}
 * 
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class CacheAdapterActivator extends AbstractUSMActivator {

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#getNeededServices()
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] { CacheService.class };
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#register(org.osgi.framework.BundleContext)
     */
    @Override
    protected void register() {
        CacheService cacheService = (CacheService) getService(CacheService.class);

        CacheManager cma = new CacheManagerAdapter(cacheService);
        registerService(CacheManager.class, cma);

        LOG.info("USM->OX CacheManagerAdapter registered");
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#unregister(org.osgi.framework.BundleContext)
     */
    @Override
    protected void unregister() {
        CacheManagerAdapter cm = (CacheManagerAdapter) getRegisteredService(CacheManager.class);
        if (cm != null)
            cm.deactivate();
        LOG.info("USM->OX CacheManagerAdapter unregistered");
    }
}
