/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.exceptions;

import org.json.JSONObject;

/**
 * Special Exception that should never be thrown if called by correctly implemented code
 * 
 * @author afe
 *
 */
public class USMIllegalArgumentException extends IllegalArgumentException implements USMJSONException {

	private static final long serialVersionUID = -1L;

	private final int _errorCode;

	public USMIllegalArgumentException(int errorCode) {
		_errorCode = errorCode;
	}

	public USMIllegalArgumentException(int errorCode, String s) {
		super(s);
		_errorCode = errorCode;
	}

	public USMIllegalArgumentException(int errorCode, Throwable cause) {
		super(cause);
		_errorCode = errorCode;
	}

	public USMIllegalArgumentException(int errorCode, String message, Throwable cause) {
		super(message, cause);
		_errorCode = errorCode;
	}

	@Override
	public String toString() {
		return Integer.toHexString(_errorCode) + ": " + super.toString();
	}

	@Override
    public JSONObject getErrorDetailsForJSONResponse() {
		return USMException.appendStacktrace(this, new JSONObject());
	}

	@Override
    public JSONObject getOxErrorForJSONResponse() {
		return null;
	}

	@Override
    public int getErrorCode() {
		return _errorCode;
	}

	@Override
    public String getErrorMessage() {
		return getMessage();
	}

}
