/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.api.datatypes;

import java.io.Serializable;
import java.util.Arrays;

/**
 * Stores all serialized information on attachments to an OX PIM object, including the last modified timestamp.
 * 
 * @author afe
 */
class SerializedPIMAttachments implements Serializable {

    private static final long serialVersionUID = 1L;

    private final long _timestamp;

    private final SerializedPIMAttachment[] _attachments;

    public SerializedPIMAttachments(PIMAttachments attachments) {
        _timestamp = attachments.getTimestamp();
        PIMAttachment[] data = attachments.getAttachments();
        _attachments = new SerializedPIMAttachment[data.length];
        for (int i = 0; i < data.length; i++) {
            _attachments[i] = new SerializedPIMAttachment(data[i]);
        }
    }

    public PIMAttachments toPIMAttachments() {
        PIMAttachment[] data = new PIMAttachment[_attachments.length];
        for (int i = 0; i < _attachments.length; i++)
            data[i] = _attachments[i].toPIMAttachment();
        return new PIMAttachments(_timestamp, data);
    }

    @Override
    public String toString() {
        return "PIMAttachments(" + _timestamp + ',' + Arrays.toString(_attachments) + ')';
    }
}
