/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.datatypes;

/**
 * Contains static definitions/identifiers for all default data types used
 * by the default USM ContentTypes.
 * 
 * @author afe
 *
 */
public class DataTypes {
	public static final StringDataType STRING = new StringDataType();
	public static final BooleanDataType BOOLEAN = new BooleanDataType();
	public static final NumberDataType NUMBER = new NumberDataType();
	public static final DateDataType DATE = new DateDataType();
	public static final TimeDataType TIME = new TimeDataType();
	public static final TimestampDataType TIMESTAMP = new TimestampDataType();
	public static final NumberNotNullDataType NUMBER_NOT_NULL = new NumberNotNullDataType();

	//used in Tasks Module
	public static final String TASKS_PARTICIPANT_IDENTIFIER = "TasksParticipantIdentifier";
	public static final String TASKS_USER_PARTICIPANT_OBJECT = "TasksUserParticipantObject";
	// Module Folders
	public static final String FOLDER_PERMISSION = "FolderPermission";

	// used in Module Contacts
	public static final String CONTACT_LINK = "Link";
	public static final String CONTACT_DISTRIBUTION_MEMBER = "Distribution_member";

	// used in Mail Module
	public static final String MAIL_HEADERS = "Headers";
	public static final String MAIL_ATTACHMENT = "Attachment";
	public static final String NESTED_MAIL = "NestedMail";
}
