/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.data;

import com.openexchange.osgi.data.AbstractDependency;
import com.openexchange.osgi.data.AbstractModule;
import com.openexchange.osgi.data.BinDirModule;
import com.openexchange.osgi.data.BundleImport;
import com.openexchange.osgi.data.Classpath;
import com.openexchange.osgi.data.JarModule;
import com.openexchange.osgi.data.JdkExports;
import com.openexchange.osgi.data.ModuleDependencies;
import com.openexchange.osgi.data.OSGIManifest;
import com.openexchange.osgi.data.RequiredBundle;
import com.openexchange.osgi.data.SourceModule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\u000fJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0007J3\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00072#\u0010\u001d\u001a\u001f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b( \u0012\u0006\u0012\u0004\u0018\u00010!0\u001eJ\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070#J\u0012\u0010$\u001a\u0004\u0018\u00010\b2\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\b2\u0006\u0010(\u001a\u00020\u0007H\u0002J\u0010\u0010)\u001a\u0004\u0018\u00010\b2\u0006\u0010*\u001a\u00020\u0007J\u0017\u0010+\u001a\u0004\u0018\u00010\b2\u0006\u0010,\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b-J\u0012\u0010.\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020\u0007H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u00072\u0006\u0010%\u001a\u00020&H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/openexchange/osgi/data/ModuleDatabase;", "", "logger", "Lorg/gradle/api/logging/Logger;", "(Lorg/gradle/api/logging/Logger;)V", "binaries", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/openexchange/osgi/data/AbstractModule;", "binariesExports", "", "modules", "Lcom/openexchange/osgi/data/SourceModule;", "modulesExports", "addBinaryModules", "", "files", "", "Ljava/io/File;", "([Ljava/io/File;)V", "addModule", "module", "clear", "computeBinaryDependencies", "getModule", "Lcom/openexchange/osgi/data/OSGIManifest;", "moduleName", "getModuleDependencies", "Lcom/openexchange/osgi/data/ModuleDependencies;", "resolver", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lorg/gradle/api/Project;", "modulesIterator", "Ljava/util/Enumeration;", "searchBinariesForBundle", "reqBundle", "Lcom/openexchange/osgi/data/RequiredBundle;", "searchBinariesForExport", "export", "searchBinariesForFilename", "filename", "searchBinariesForProject", "projectName", "searchBinariesForProject$osgi", "searchModulesForExport", "searchProjectsForBundle", "osgi"})
public final class ModuleDatabase {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<String, SourceModule> modules;
    @NotNull
    private final ConcurrentHashMap<String, Set<SourceModule>> modulesExports;
    @NotNull
    private final ConcurrentHashMap<String, AbstractModule> binaries;
    @NotNull
    private final ConcurrentHashMap<String, Set<AbstractModule>> binariesExports;

    public ModuleDatabase(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.modules = new ConcurrentHashMap();
        this.modulesExports = new ConcurrentHashMap();
        this.binaries = new ConcurrentHashMap();
        this.binariesExports = new ConcurrentHashMap();
    }

    public final void addModule(@NotNull SourceModule module) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            SourceModule sourceModule = this.modules.get(module.getName());
            if (sourceModule != null) {
                SourceModule other = sourceModule;
                boolean bl = false;
                throw new GradleException("Duplicate module " + module.getName() + " found " + module.getFile().getAbsolutePath() + ". Other module is " + other.getFile().getAbsolutePath() + '.');
            }
            ((Map)this.modules).put(module.getName(), module);
            Set<String> set = module.getManifest().getExports();
            Intrinsics.checkNotNullExpressionValue(set, (String)"module.manifest.exports");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String export = (String)element$iv;
                boolean bl = false;
                this.modulesExports.compute(export, (arg_0, arg_1) -> ModuleDatabase.addModule$lambda$2$lambda$1((Function2)new Function2<String, Set<? extends SourceModule>, Set<? extends SourceModule>>(module, this, export){
                    final /* synthetic */ SourceModule $module;
                    final /* synthetic */ ModuleDatabase this$0;
                    final /* synthetic */ String $export;
                    {
                        this.$module = $module;
                        this.this$0 = $receiver;
                        this.$export = $export;
                        super(2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Set<SourceModule> invoke(@NotNull String string, @Nullable Set<SourceModule> current) {
                        Set set;
                        Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                        Set set2 = current;
                        if (set2 != null && (set2 = SetsKt.plus(set2, (Object)this.$module)) != null) {
                            Collection<String> collection;
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            Set set3 = set2;
                            ModuleDatabase moduleDatabase = this.this$0;
                            SourceModule sourceModule = this.$module;
                            String string2 = this.$export;
                            Set it = set3;
                            boolean bl = false;
                            Iterable iterable = current;
                            StringBuilder stringBuilder = new StringBuilder().append(sourceModule.getManifest().getEntry("Bundle-SymbolicName")).append(" exports ").append(string2).append(" which is already registered and exported from ");
                            Logger logger = ModuleDatabase.access$getLogger$p(moduleDatabase);
                            boolean $i$f$map = false;
                            void var13_13 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it2;
                                SourceModule sourceModule2 = (SourceModule)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl2 = false;
                                collection.add(it2.getName());
                            }
                            collection = (List)destination$iv$iv;
                            logger.warn(stringBuilder.append(collection).toString());
                            set = set3;
                        } else {
                            set = SetsKt.setOf((Object)this.$module);
                        }
                        return set;
                    }
                }, arg_0, arg_1));
            }
            this.logger.info("{}: Added: {} as bundle to the Module-Database", (Object)"OSGi-Plugin", (Object)module.getName());
            AbstractModule abstractModule = this.binaries.get(module.getName());
            if (abstractModule == null) break block2;
            AbstractModule it = abstractModule;
            boolean bl = false;
            Object[] objectArray = new Object[]{"OSGi-Plugin", module.getName(), it.getFile().getAbsolutePath()};
            this.logger.warn("{}: Duplicate module {} found in {}.", objectArray);
        }
    }

    @NotNull
    public final Enumeration<String> modulesIterator() {
        Enumeration<String> enumeration = this.modules.keys();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"modules.keys()");
        return enumeration;
    }

    @Nullable
    public final OSGIManifest getModule(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        SourceModule sourceModule = this.modules.get(moduleName);
        return sourceModule != null ? sourceModule.getManifest() : null;
    }

    public final void addBinaryModules(File ... files) throws IOException {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        File[] $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            AbstractModule abstractModule;
            File element$iv;
            File file = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (file.isFile()) {
                abstractModule = new JarModule(file);
            } else if (file.isDirectory()) {
                abstractModule = new BinDirModule(file, true);
            } else {
                throw new IOException("Don't know how to handle " + file.getAbsolutePath());
            }
            AbstractModule module = abstractModule;
            Set<String> set = module.getExportedPackages();
            Intrinsics.checkNotNullExpressionValue(set, (String)"module.exportedPackages");
            Iterable $this$forEach$iv2 = set;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String exportedPackage = (String)element$iv2;
                boolean bl2 = false;
                this.binariesExports.compute(exportedPackage, (arg_0, arg_1) -> ModuleDatabase.addBinaryModules$lambda$7$lambda$5$lambda$4((Function2)new Function2<String, Set<? extends AbstractModule>, Set<? extends AbstractModule>>(module, this, exportedPackage){
                    final /* synthetic */ AbstractModule $module;
                    final /* synthetic */ ModuleDatabase this$0;
                    final /* synthetic */ String $exportedPackage;
                    {
                        this.$module = $module;
                        this.this$0 = $receiver;
                        this.$exportedPackage = $exportedPackage;
                        super(2);
                    }

                    @Nullable
                    public final Set<AbstractModule> invoke(@NotNull String string, @Nullable Set<? extends AbstractModule> current) {
                        Set set;
                        Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                        Set set2 = current;
                        if (set2 != null && (set2 = SetsKt.plus(set2, (Object)this.$module)) != null) {
                            Set set3 = set2;
                            ModuleDatabase moduleDatabase = this.this$0;
                            AbstractModule abstractModule = this.$module;
                            String string2 = this.$exportedPackage;
                            Set it = set3;
                            boolean bl = false;
                            ModuleDatabase.access$getLogger$p(moduleDatabase).warn(abstractModule.name + " exports package " + string2 + " which is already exported from " + current);
                            set = set3;
                        } else {
                            set = SetsKt.setOf((Object)this.$module);
                        }
                        return set;
                    }
                }, arg_0, arg_1));
            }
            AbstractModule abstractModule2 = this.binaries.get(module.name);
            if (abstractModule2 != null) {
                AbstractModule other = abstractModule2;
                boolean bl3 = false;
                throw new IOException("Duplicate module " + module.name + " found " + module.file.getAbsolutePath() + ". Other module is " + other.getFile().getAbsolutePath() + '.');
            }
            Map map = this.binaries;
            String string = module.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
            map.put(string, module);
        }
        this.logger.info("{}: Added binary modules to the Module-Database", (Object)"OSGi-Plugin");
    }

    public final void computeBinaryDependencies() {
        Collection<AbstractModule> collection = this.binaries.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"binaries.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractModule module = (AbstractModule)element$iv;
            boolean bl = false;
            module.computeDependencies((Map<String, AbstractModule>)this.binaries, (Map<String, Set<AbstractModule>>)this.binariesExports, MapsKt.emptyMap(), false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ModuleDependencies getModuleDependencies(@NotNull String moduleName, @NotNull Function1<? super String, ? extends Project> resolver) throws GradleException {
        Object it;
        void $this$mapTo$iv$iv;
        Iterator<AbstractDependency> $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
        SourceModule sourceModule = this.modules.get(moduleName);
        if (sourceModule == null) {
            throw new GradleException("Module " + moduleName + " could not be found.");
        }
        SourceModule module = sourceModule;
        OSGIManifest myManifest = module.getManifest();
        ModuleDependencies myDependencies = new ModuleDependencies();
        Set<RequiredBundle> requiredBundles = myManifest.getRequiredBundles();
        Set<RequiredBundle> set = myManifest.getFragmentHost();
        Intrinsics.checkNotNullExpressionValue(set, (String)"myManifest.fragmentHost");
        Iterable iterable = set;
        Set<RequiredBundle> set2 = requiredBundles;
        boolean $i$f$map = false;
        void var9_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            RequiredBundle requiredBundle = (RequiredBundle)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Intrinsics.areEqual((Object)it2.getPackageName(), (Object)"system.bundle") ? new RequiredBundle("org.eclipse.osgi") : it2);
        }
        set2.addAll((List)destination$iv$iv);
        for (RequiredBundle reqBundle : requiredBundles) {
            boolean bl;
            boolean bl2;
            if (Intrinsics.areEqual((Object)reqBundle.getPackageName(), (Object)"system.bundle")) continue;
            Intrinsics.checkNotNullExpressionValue((Object)reqBundle, (String)"reqBundle");
            it = this.searchBinariesForBundle(reqBundle);
            boolean bl3 = false;
            if (it == null) {
                bl2 = false;
            } else {
                myDependencies.addBinary((AbstractModule)it);
                bl2 = true;
            }
            if (bl2) continue;
            it = this.searchProjectsForBundle(reqBundle);
            boolean bl4 = false;
            if (it == null) {
                bl = false;
            } else {
                myDependencies.addProject((String)it);
                bl = true;
            }
            if (bl || reqBundle.isOptional()) continue;
            throw new GradleException("OSGi-Plugin: Could not find required Bundle: " + reqBundle.getPackageName() + " for: " + moduleName + " in Module-Database");
        }
        for (BundleImport myImport : myManifest.getImports()) {
            boolean bl;
            boolean bl5;
            if (myManifest.getExports().contains(myImport.getPackageName())) {
                this.logger.warn(moduleName + ": is importing and exporting the same package " + myImport.getPackageName());
                continue;
            }
            String string = myImport.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myImport.packageName");
            if (JdkExports.Companion.exports(string)) continue;
            String string2 = myImport.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"myImport.packageName");
            it = this.searchBinariesForExport(string2);
            boolean bl6 = false;
            if (it == null) {
                bl5 = false;
            } else {
                myDependencies.addBinary((AbstractModule)it);
                bl5 = true;
            }
            if (bl5) continue;
            String string3 = myImport.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"myImport.packageName");
            it = this.searchModulesForExport(string3);
            boolean bl7 = false;
            if (it == null) {
                bl = false;
            } else {
                myDependencies.addProject((String)it);
                bl = true;
            }
            if (bl || myImport.isOptional()) continue;
            throw new GradleException("OSGi-Plugin: Couldn't find required Export: " + myImport.getPackageName() + " for: " + moduleName + " in module database");
        }
        Object object = module.getClassPath();
        if (object == null || (object = ((Classpath)object).getProjectDependencies()) == null) {
            object = SetsKt.emptySet();
        }
        Object projectDependencies = object;
        Iterator iterator = projectDependencies.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            boolean bl8;
            boolean bl9;
            String projectDependency = (String)iterator.next();
            Object it3 = this.modules.get(projectDependency);
            boolean bl10 = false;
            if (it3 == null) {
                bl9 = false;
            } else {
                myDependencies.addProjectForTests(((SourceModule)it3).getProjectPath());
                bl9 = true;
            }
            if (bl9) continue;
            it3 = this.binaries.get(projectDependency);
            boolean bl11 = false;
            if (it3 == null) {
                bl8 = false;
            } else {
                myDependencies.addBinaryForTests((AbstractModule)it3);
                bl8 = true;
            }
            if (bl8) continue;
            it3 = (Project)resolver.invoke((Object)projectDependency);
            boolean bl12 = false;
            if (it3 == null) {
                bl = false;
            } else {
                String string = it3.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
                myDependencies.addProjectForTests(string);
                bl = true;
            }
            if (bl) continue;
            throw new GradleException("OSGi-Plugin: Could not resolve project dependency of " + module.getName() + " to project " + projectDependency);
        }
        Classpath classpath = module.getClassPath();
        myDependencies.setJunit4(classpath != null ? classpath.hasJUnitClasspathContainer() : false);
        return myDependencies;
    }

    private final String searchProjectsForBundle(RequiredBundle reqBundle) {
        SourceModule sourceModule = this.modules.get(reqBundle.getPackageName());
        return sourceModule != null ? sourceModule.getProjectPath() : null;
    }

    private final AbstractModule searchBinariesForBundle(RequiredBundle reqBundle) {
        for (AbstractModule binary : this.binaries.values()) {
            if (!Intrinsics.areEqual((Object)binary.getSymbolicName(), (Object)reqBundle.getPackageName())) continue;
            return binary;
        }
        return null;
    }

    @Nullable
    public final AbstractModule searchBinariesForProject$osgi(@NotNull String projectName) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        return this.binaries.get(projectName);
    }

    @Nullable
    public final AbstractModule searchBinariesForFilename(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        for (AbstractModule binary : this.binaries.values()) {
            if (!Intrinsics.areEqual((Object)binary.file.getName(), (Object)filename)) continue;
            return binary;
        }
        return null;
    }

    private final AbstractModule searchBinariesForExport(String export) {
        Set<AbstractModule> set = this.binariesExports.get(export);
        return set != null ? (AbstractModule)CollectionsKt.first((Iterable)set) : null;
    }

    private final String searchModulesForExport(String export) {
        Set<SourceModule> set = this.modulesExports.get(export);
        return set != null && (set = (SourceModule)CollectionsKt.first((Iterable)set)) != null ? ((SourceModule)((Object)set)).getProjectPath() : null;
    }

    public final void clear() {
        this.modules.clear();
        this.modulesExports.clear();
        this.binaries.clear();
        this.binariesExports.clear();
    }

    private static final Set addModule$lambda$2$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0, p1);
    }

    private static final Set addBinaryModules$lambda$7$lambda$5$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Logger access$getLogger$p(ModuleDatabase $this) {
        return $this.logger;
    }
}

