/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.util;

import java.util.Collection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.osgi.framework.ServiceReference;

/**
 * {@link OSGiToolkit}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class OSGiToolkit {

    /**
     * Creates a service filter for the specified classes
     * 
     * @param clazz
     * @return the service filter as string
     */
    public static String createServiceFilter(Class<?> clazz[]) {
        StringBuilder builder = new StringBuilder();
        builder.append("(|");
        for(Class<?> c : clazz) {
            builder.append("(objectclass=").append(c.getName().toString()).append(")");
        }
        builder.append(")");
        return builder.toString();
    }
    
    /**
     * Verifies if the given list of services are present.
     * 
     * @param o
     * @return
     */
    public static boolean allServicesPresent(Collection<ServiceReference<?>> services) {
        for (ServiceReference<?> s : services) {
            if (s == null) return false;
        }
        return true;
    }
    
    /**
     * Creates an appropriate instance of {@link ObjectName} from specified class name and domain name.
     *
     * @param className The class name to use as object name
     * @param domain The domain name
     * @return An appropriate instance of {@link ObjectName}
     * @throws MalformedObjectNameException If instantiation of {@link ObjectName} fails
     */
    public static ObjectName getObjectName(final String className, final String domain) throws MalformedObjectNameException {
        final int pos = className.lastIndexOf('.');
        return new ObjectName(domain, "name", pos == -1 ? className : className.substring(pos + 1));
    }
}