/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.session.tasks;

import org.apache.commons.logging.Log;
import com.openexchange.usm.session.impl.SessionManagerImpl;

/**
 * {@link USMSessionCacheCleanupLogInfoTask}
 * 
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class USMSessionCacheCleanupLogInfoTask implements Runnable {

    private final SessionManagerImpl _sessionManager;

    public USMSessionCacheCleanupLogInfoTask(SessionManagerImpl manager) {
        _sessionManager = manager;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Runnable#run()
     */
    @Override
    public void run() {
        Log log = _sessionManager.getJournal();
        int removedSessions = _sessionManager.getUSMCacheInformation().getSessionsRemovedSinceLastLogging();
        int jvmRemovals = _sessionManager.getUSMCacheInformation().getSessionsRemovedByJVMSinceLastLogging();
        int removedSyncStates = _sessionManager.getUSMCacheInformation().getSyncStatesRemovedSinceLastLogging();
        log.info(removedSessions + " USM sessions (and " + jvmRemovals + " by JVM) and " + removedSyncStates + " SyncStates have been removed from memory cache since the last cleanup task.");
        //        SyncStateStorageStatistics.reportStatistics(log);
    }
}
